//
//  DKViewController+GestureRecognisers.h
//  GCDrawKit
//
//  Created by Graham Cox on 29/06/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import "DKViewController.h"

@interface DKViewController (GestureRecognisers)


- (void)		addGestureRecogniser:(DKGestureRecogniser*) gr;
- (void)		removeGestureRecogniser:(DKGestureRecogniser*) gr;
- (NSSet*)		gestureRecognisers;

- (void)		didReceiveTwoFingerDoubleTap:(NSDictionary*) userInfo;

@end


/*

Gesture recognisers are objects attached to the view controller that respond to touch events. When they recognise a specific gesture,
 they call back the delegate which responds in some appropriate manner.
 
 The default behaviour is to invoke the method given by a selector attached to the recogniser, passing it any userInfo dictionary
 assigned.
 
 This implements a standard handler for the 2-finger double-tap, which is "Smart Zoom". The default recognizer is set up in the -init method.

*/