///**********************************************************************************************************************************
///  DKZoomTool.m
///  DrawKit ©2005-2008 Apptree.net
///
///  Created by graham on 25/03/2008.
///
///	 This software is released subject to licensing conditions as detailed in DRAWKIT-LICENSING.TXT, which must accompany this source file. 
///
///**********************************************************************************************************************************


#import <Cocoa/Cocoa.h>
#import "DKDrawingTool.h"


typedef enum
{
	kDKZoomIn		= 0,
	kDKZoomOut		= 1
}
DKZoomMode;



@interface DKZoomTool : DKDrawingTool
{
@private
	DKZoomMode	mDefaultMode;			// natural mode for the tool
	DKZoomMode	mActualMode;			// actual mode for the tool - may be altered from default by modifier keys
	NSUInteger	mModeModifierMask;		// modifier mask used to flip mode in response to modifier
	NSPoint		mAnchor;				// initial click pt
	NSRect		mZoomRect;				// zoom rect when dragged
}


- (void)		setNaturalZoomMode:(DKZoomMode) mode;
- (DKZoomMode)	naturalZoomMode;

- (void)		setModeModifierMask:(NSUInteger) msk;
- (NSUInteger)	modeModifierMask;

@end


@interface DKZoomTool (Deprecated)

- (void)		setZoomsOut:(BOOL) zoomOut;
- (BOOL)		zoomsOut;

@end



/*

This tool implements a zoom "magnifier" tool. It can zoom in, zoom out or zoom in to a dragged rect. It does not affect
the data content of the drawing, only the view that is applying it, so does not generate any undo tasks.


*/


