//
//  GCCache.h
//  GCDrawKit
//
//  Created by graham on 2/07/10.
//  Copyright 2010 Apptree.net. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface GCCacheDictionary : NSObject
{
@private
	NSMutableDictionary*	mStore;
	NSMutableArray*			mUsedKeysArray;
	NSUInteger				mLimit;
}

+ (id)			cache;
+ (NSArray*)	allCaches;
+ (void)		removeCache:(GCCacheDictionary*) cd;
+ (void)		discardHalf;

- (void)		setObject:(id) obj forKey:(NSString*) key;
- (id)			objectForKey:(NSString*) key;
- (void)		removeObjectForKey:(NSString*) key;
- (void)		removeAllObjects;
- (NSUInteger)	count;

- (void)		setCountLimit:(NSUInteger) limit;
- (NSUInteger)	countLimit;

- (void)		discardHalf;

@end



/*

Acts as a mutable dictionary but with a fixed count of objects. If adding beyond the limit, the
least recently used items are removed to make space.
 
 If count limit is 0, acts exactly like a dictionary.


*/


