//
//  GCLogger.h
//  GCDrawKit
//
//  Created by Graham Cox on 12/08/12.
//  Copyright (c) 2012 Apptree. All rights reserved.
//

#import <Foundation/Foundation.h>


#define GC_LOGGING_ENABLED			1



@interface GCLogger : NSObject
{
@private
	NSMutableSet*		mEnabledLoggingTags;
	NSMutableSet*		mRegisteredLoggingTags;
}

+ (GCLogger*)		defaultLogger;

- (NSSet*)			enabledTags;
- (NSSet*)			registeredTags;

- (void)			enableTag:(NSString*) tag;
- (void)			disableTag:(NSString*) tag;
- (BOOL)			isTagEnabled:(NSString*) tag;
- (void)			enableAll:(BOOL) doIt;

- (void)			logMessageWithTag:(NSString*) tag format:(NSString*) format, ...;

- (void)			registerTag:(NSString*) tag;
- (void)			unregisterTag:(NSString*) tag;

@end



#ifdef __cplusplus
extern "C" {
#endif
	
	void	GCLog( NSString* tag, NSString* format, ... );
	void	GCLogObjCMethod( id obj, SEL selector, NSUInteger lineNumber, NSString* tag, NSString* format, ... );
	
	
#ifdef __cplusplus
}
#endif

#if GC_LOGGING_ENABLED

#define GCLOG													GCLog
#define GCLOGOC( format, ... )									GCLogObjCMethod( self, _cmd, __LINE__, NSStringFromClass([self class]), format, ##__VA_ARGS__ )
#define GCLOGOCT( tag, format, ... )							GCLogObjCMethod( self, _cmd, __LINE__, tag, format, ##__VA_ARGS__ )


#ifdef LogEvent_
#undef LogEvent_
#endif

#define LogEvent_		GCLog

#else

#define GCLOG
#define GCLOGOC
#define GCLOGOCT

#endif



/*
 
 This is the intended replacement for the execrable 'LogEvent' code, which is far too coarse-grained and hard to extend.
 
 This logger can be dynamically extended on the fly. Logging can be tagged using any defined name or using the class name.
 
 
 
 
 
 
 
 
 
 
 
 */

