//
//  NSBezierPath+SmarterFlatten.h
//  DrawKit
//
//  Created by Graham on 21/06/11.
//  Copyright 2011 Mapdiva, LLC. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface NSBezierPath (SmarterFlatten)




- (NSBezierPath*)		bezierPathBySmartFlatteningPath;
- (NSBezierPath*)		bezierPathBySmartFlatteningPathWithFlatness:(CGFloat) flatness;

@end


/*

 The standard way a path is flattened does not take into account the possibility that a curve segment may in fact describe a straight line, and so unnecessarily multiplies
 the number of line segments needed to replacethat curve segment. This method tests whether a curve segment describes a straight line, and if so replaces it with a single
 line element rather than tens or hundreds.

*/

