var logo;
var retina = !!(window.devicePixelRatio > 1);
if(retina)
	$('html').addClass('retina');
$(function(){
	var request;
	if(location.protocol == 'file:'){
		if(!retina)
			logo = '../shared/appicon_128.png';
		else
			logo = '../Shared/appicon_128@2x.png';
		var path = location.pathname.split('/');
		path.pop();
		path = 'file://' + path.join('/');
		request = new XMLHttpRequest();
		request.open('GET', path + '/content.json', false);
		request.send(null);
		init(request.responseText);
	} else {
		if(!retina)
			logo = '../shared/appicon_128.png';
		else
			logo = '../Shared/appicon_128@2x.png';

		var template = $('<div class="spinner">&nbsp;</div>');
		lightbox = new Lightbox({'content': template, 'width': 50, 'class': 'progress'});

		$("#topBar").hide();

		function onProgress(e){
			var h = this.getAllResponseHeaders();
			var m = h.match(/X-Length: (\d+)/);
			if(m && m.length > 0){
				var total = m[1];
				$('.lightbox .content span').width(e.loaded / total * 105 + '%'); // 105 -- to adjust the scale a bit
			}
		}
		function onLoad(){
			lightbox.close();
			webInit(this.responseText);
		}

		request = new XMLHttpRequest();
		request.onprogress = onProgress;
		request.open("GET", '../content.json', true);
		request.onload = onLoad;
		request.send(null);

	}
});

function dump(o){
	return JSON.stringify(o,null,'\t').replace(/\n/g,'<br>').replace(/\t/g,'&nbsp;&nbsp;&nbsp;');
}

function webInit(data){
	$("#content").remove();
	$("#menu").remove();
	init(data);
}



function init(data){
	data = JSON.parse(data);
	var content = data.content;
	var menu = makeTree(data.hierarchy, false);
	var current;

	$(window).bind('hashchange', function(){
		if(document.location.hash){
			load(document.location.hash.substring(1));
		} else {
			loadHomePage();
		}
	});

	$("body").append($("<div id='menu'>").append(menu));
	$("body").append($("<div id='content'>"));

	$("body").bind('mousedown', deselect);

	if(document.location.hash){
		load(document.location.hash.substring(1));
	} else {
		loadHomePage();
	}

	function makeTree(tree, hide){
		var menu = $("<ul>");
		if(hide){
			menu.hide();
		}
		for(var i = 0, l = tree.length; i < l; i++){
			var item = $("<li>");
			var link = $("<a>");
			link.text(content[tree[i].id].name);
			link.attr({'href': '#' + tree[i].id});
			item.append(link);
			var sub = false;
			if(children = tree[i].children){
				sub = makeTree(children, true);
				item.addClass('openable');
				link.removeAttr('href');
				item.append(sub);
				item.click(function(e){
					deselect();
					e.stopPropagation();
					$(this).toggleClass("open");
				});
				link.bind('click', function(e){ e.preventDefault(); });
			} else {
				link.bind('click', menuClick);
			}
			menu.append(item);
		}
		return menu;
	}
	function menuClick(e){
		deselect();
		e.stopPropagation();
	}
	function load(id){
		var a = $("#menu a[href='#" + id + "']");
		if(!a.length)
			return false;
		a.parents('li').addClass('open');
		a.addClass('active');
		var text = content[id].content;
		$("#content").html(text);
		if(current){
			current.removeClass('active');
		}

		bindQuestions();

		current = a;
		$("#content ol > li > ol").attr({'type': 'A'}).addClass('alpha');
		$("#content ol > li > ol > li").each(function(){
			var el = $(this);
			el.wrapInner('<div></div>');
		});

		document.title = 'Mapdiva Help: ' + $("#content h1").text();

		var see = $('p:contains("SEE ALSO")');
		see.addClass('see');
		var also = $('p:contains("SEE ALSO") ~ p');
		also.addClass('also');

		$("#content").scrollTop(0);

		retinize($("#content"));

		$("#content h1").prepend('<img src="css/img/icon' + (retina? '@2x' : '') + '.png" class="print" width="32" height="32">');

		try{
			var l = document.location.hash.replace(/#/, '/?id=');
			_gaq.push(['_trackPageview', l]);
		} catch(e){
			// meh
		}

	}
}

function loadHomePage(){
	$("#content").html('<div id="home"><div class="wrap"><img width="203" height="215" src="' + logo + '" /><h1>Mapdiva Help</h1><p>Click a topic on the left or type in the search field above.</p></div></div>');
	$("#resultWrap").hide();
	$("#search input").val('');
	document.title = 'Mapdiva Help';
}

function bindQuestions(){
	var questions = $("#content .question");
	if(questions.length){
		questions.each(function(){
			var q = $(this);
			var t = q.find('.title');
			t.prepend($('<a class="show">Show</a><a class="hide">Hide</a>'));
			t.click(function(){
				deselect();
				q.toggleClass('open');
			});
			if(questions.length === 1){
				t.click();
			}
		});
	}
}

function deselect(){
	var sel;
	if(document.selection && document.selection.empty){
		document.selection.empty();
	} else if(window.getSelection){
		sel = window.getSelection();
		if(sel && sel.removeAllRanges)
		sel.removeAllRanges();
	}
}

function retinize($context){
	if(!retina)
		return false;
	$context.find('img').each(function(){
		var img = $(this);
		var rSrc = this.src;
		rSrc = rSrc.replace(/\.(gif|jpe?g|png)$/, '@2x.$1');
		var rImg = new Image();
		rImg.onload = (function(img, rimg){
			return function(){
				img.replaceWith($(rimg).attr({'width': rimg.width / 2, 'height': rimg.height / 2}));
			};
		})(img, rImg);
		rImg.src = rSrc;
	});
	return true;
}

