(function() {
  var ArchiveEditorView, DirectoryView, FileView, ScrollView, archive, fs, humanize,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  ScrollView = require('atom-space-pen-views').ScrollView;

  fs = require('fs-plus');

  humanize = require('humanize-plus');

  archive = require('ls-archive');

  FileView = require('./file-view');

  DirectoryView = require('./directory-view');

  module.exports = ArchiveEditorView = (function(_super) {
    __extends(ArchiveEditorView, _super);

    function ArchiveEditorView() {
      return ArchiveEditorView.__super__.constructor.apply(this, arguments);
    }

    ArchiveEditorView.content = function() {
      return this.div({
        "class": 'archive-editor',
        tabindex: -1
      }, (function(_this) {
        return function() {
          return _this.div({
            "class": 'archive-container'
          }, function() {
            _this.div({
              outlet: 'loadingMessage',
              "class": 'padded icon icon-hourglass text-info'
            }, 'Loading archive\u2026');
            _this.div({
              outlet: 'errorMessage',
              "class": 'padded icon icon-alert text-error'
            });
            return _this.div({
              "class": 'inset-panel'
            }, function() {
              _this.div({
                outlet: 'summary',
                "class": 'panel-heading'
              });
              return _this.ol({
                outlet: 'tree',
                "class": 'archive-tree padded list-tree has-collapsable-children'
              });
            });
          });
        };
      })(this));
    };

    ArchiveEditorView.prototype.initialize = function(editor) {
      var commandDisposable;
      commandDisposable = ArchiveEditorView.__super__.initialize.call(this);
      commandDisposable.dispose();
      this.setModel(editor);
      return this.on('focus', (function(_this) {
        return function() {
          _this.focusSelectedFile();
          return false;
        };
      })(this));
    };

    ArchiveEditorView.prototype.setPath = function(path) {
      if (path && this.path !== path) {
        this.path = path;
        return this.refresh();
      }
    };

    ArchiveEditorView.prototype.refresh = function() {
      var originalPath;
      this.summary.hide();
      this.tree.hide();
      this.loadingMessage.show();
      this.errorMessage.hide();
      originalPath = this.path;
      return archive.list(this.path, {
        tree: true
      }, (function(_this) {
        return function(error, entries) {
          var message;
          if (originalPath !== _this.path) {
            return;
          }
          _this.loadingMessage.hide();
          if (error != null) {
            message = 'Reading the archive file failed';
            if (error.message) {
              message += ": " + error.message;
            }
            return _this.errorMessage.show().text(message);
          } else {
            _this.createTreeEntries(entries);
            return _this.updateSummary();
          }
        };
      })(this));
    };

    ArchiveEditorView.prototype.createTreeEntries = function(entries) {
      var entry, _i, _len, _ref;
      this.tree.empty();
      for (_i = 0, _len = entries.length; _i < _len; _i++) {
        entry = entries[_i];
        if (entry.isDirectory()) {
          this.tree.append(new DirectoryView(this.path, entry));
        } else {
          this.tree.append(new FileView(this.path, entry));
        }
      }
      this.tree.show();
      return (_ref = this.tree.find('.file').view()) != null ? _ref.select() : void 0;
    };

    ArchiveEditorView.prototype.updateSummary = function() {
      var directoryCount, directoryLabel, fileCount, fileLabel;
      fileCount = this.tree.find('.file').length;
      fileLabel = fileCount === 1 ? "1 file" : "" + (humanize.intComma(fileCount)) + " files";
      directoryCount = this.tree.find('.directory').length;
      directoryLabel = directoryCount === 1 ? "1 folder" : "" + (humanize.intComma(directoryCount)) + " folders";
      return this.summary.text("" + (humanize.fileSize(fs.getSizeSync(this.path))) + " with " + fileLabel + " and " + directoryLabel).show();
    };

    ArchiveEditorView.prototype.focusSelectedFile = function() {
      var _ref;
      return (_ref = this.tree.find('.selected').view()) != null ? _ref.focus() : void 0;
    };

    ArchiveEditorView.prototype.focus = function() {
      return this.focusSelectedFile();
    };

    ArchiveEditorView.prototype.setModel = function(editor) {
      if (this.editor) {
        this.unsubscribe(this.editor);
      }
      if (editor) {
        this.editor = editor;
        this.setPath(editor.getPath());
        editor.file.onDidChange((function(_this) {
          return function() {
            return _this.refresh();
          };
        })(this));
        return editor.file.onDidDelete((function(_this) {
          return function() {
            var _ref;
            return (_ref = atom.workspace.paneForItem(_this.editor)) != null ? _ref.destroyItem(_this.editor) : void 0;
          };
        })(this));
      }
    };

    return ArchiveEditorView;

  })(ScrollView);

}).call(this);
