(function() {
  var ArchiveEditor, File, Serializable, fs, isPathSupported, path,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  File = require('pathwatcher').File;

  fs = require('fs-plus');

  Serializable = require('serializable');

  isPathSupported = function(filePath) {
    switch (path.extname(filePath)) {
      case '.egg':
      case '.epub':
      case '.jar':
      case '.love':
      case '.tar':
      case '.tgz':
      case '.war':
      case '.whl':
      case '.xpi':
      case '.zip':
        return true;
      case '.gz':
        return path.extname(path.basename(filePath, '.gz')) === '.tar';
      default:
        return false;
    }
  };

  module.exports = ArchiveEditor = (function(_super) {
    __extends(ArchiveEditor, _super);

    atom.deserializers.add(ArchiveEditor);

    ArchiveEditor.activate = function() {
      return atom.workspace.addOpener(function(filePath) {
        if (filePath == null) {
          filePath = '';
        }
        if (isPathSupported(filePath) && fs.isFileSync(filePath)) {
          return new ArchiveEditor({
            path: filePath
          });
        }
      });
    };

    function ArchiveEditor(_arg) {
      var path;
      path = _arg.path;
      this.file = new File(path);
    }

    ArchiveEditor.prototype.serializeParams = function() {
      return {
        path: this.getPath()
      };
    };

    ArchiveEditor.prototype.deserializeParams = function(params) {
      if (params == null) {
        params = {};
      }
      if (fs.isFileSync(params.path)) {
        return params;
      } else {
        return console.warn("Could not build archive editor for path '" + params.path + "' because that file no longer exists");
      }
    };

    ArchiveEditor.prototype.getPath = function() {
      return this.file.getPath();
    };

    ArchiveEditor.prototype.destroy = function() {
      var _ref;
      return (_ref = this.file) != null ? _ref.off() : void 0;
    };

    ArchiveEditor.prototype.getViewClass = function() {
      return require('./archive-editor-view');
    };

    ArchiveEditor.prototype.getTitle = function() {
      if (this.getPath() != null) {
        return path.basename(this.getPath());
      } else {
        return 'untitled';
      }
    };

    ArchiveEditor.prototype.getURI = function() {
      return this.getPath();
    };

    ArchiveEditor.prototype.isEqual = function(other) {
      return other instanceof ArchiveEditor && this.getURI() === other.getURI();
    };

    return ArchiveEditor;

  })(Serializable);

}).call(this);
