(function() {
  var DirectoryView, FileView, View,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  View = require('atom-space-pen-views').View;

  FileView = require('./file-view');

  module.exports = DirectoryView = (function(_super) {
    __extends(DirectoryView, _super);

    function DirectoryView() {
      return DirectoryView.__super__.constructor.apply(this, arguments);
    }

    DirectoryView.content = function(archivePath, entry) {
      return this.li({
        "class": 'list-nested-item entry'
      }, (function(_this) {
        return function() {
          _this.span({
            "class": 'list-item'
          }, function() {
            return _this.span(entry.getName(), {
              "class": 'directory icon icon-file-directory'
            });
          });
          return _this.ol({
            "class": 'list-tree',
            outlet: 'entries'
          });
        };
      })(this));
    };

    DirectoryView.prototype.initialize = function(archivePath, entry) {
      var child, _i, _len, _ref, _results;
      _ref = entry.children;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        child = _ref[_i];
        if (child.isDirectory()) {
          _results.push(this.entries.append(new DirectoryView(archivePath, child)));
        } else {
          _results.push(this.entries.append(new FileView(archivePath, child)));
        }
      }
      return _results;
    };

    return DirectoryView;

  })(View);

}).call(this);
