(function() {
  var $, FileView, View, archive, fs, path, temp, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ref = require('atom-space-pen-views'), $ = _ref.$, View = _ref.View;

  fs = require('fs-plus');

  temp = require('temp');

  archive = require('ls-archive');

  module.exports = FileView = (function(_super) {
    __extends(FileView, _super);

    function FileView() {
      return FileView.__super__.constructor.apply(this, arguments);
    }

    FileView.content = function(archivePath, entry) {
      return this.li({
        "class": 'list-item entry',
        tabindex: -1
      }, (function(_this) {
        return function() {
          return _this.span(entry.getName(), {
            "class": 'file icon',
            outlet: 'name'
          });
        };
      })(this));
    };

    FileView.prototype.initialize = function(archivePath, entry) {
      this.archivePath = archivePath;
      this.entry = entry;
      if (this.entry.isSymbolicLink()) {
        this.name.addClass('icon-file-symlink-file');
      } else {
        this.name.addClass('icon-file-text');
      }
      this.on('click', (function(_this) {
        return function() {
          _this.select();
          return _this.openFile();
        };
      })(this));
      return atom.commands.add(this.element, {
        'core:confirm': (function(_this) {
          return function() {
            if (_this.isSelected()) {
              return _this.openFile();
            }
          };
        })(this),
        'core:move-down': (function(_this) {
          return function() {
            var files, _ref1;
            if (_this.isSelected()) {
              files = _this.closest('.archive-editor').find('.file');
              return (_ref1 = $(files[files.index(_this.name) + 1]).view()) != null ? _ref1.select() : void 0;
            }
          };
        })(this),
        'core:move-up': (function(_this) {
          return function() {
            var files, _ref1;
            if (_this.isSelected()) {
              files = _this.closest('.archive-editor').find('.file');
              return (_ref1 = $(files[files.index(_this.name) - 1]).view()) != null ? _ref1.select() : void 0;
            }
          };
        })(this)
      });
    };

    FileView.prototype.isSelected = function() {
      return this.hasClass('selected');
    };

    FileView.prototype.logError = function(message, error) {
      var _ref1;
      return console.error(message, (_ref1 = error.stack) != null ? _ref1 : error);
    };

    FileView.prototype.openFile = function() {
      return archive.readFile(this.archivePath, this.entry.getPath(), (function(_this) {
        return function(error, contents) {
          if (error != null) {
            return _this.logError("Error reading: " + (_this.entry.getPath()) + " from " + _this.archivePath, error);
          } else {
            return temp.mkdir('atom-', function(error, tempDirPath) {
              var tempFilePath;
              if (error != null) {
                return _this.logError("Error creating temp directory: " + tempDirPath, error);
              } else {
                tempFilePath = path.join(tempDirPath, path.basename(_this.archivePath), _this.entry.getName());
                return fs.writeFile(tempFilePath, contents, function(error) {
                  if (error != null) {
                    return _this.logError("Error writing to " + tempFilePath, error);
                  } else {
                    return atom.workspace.open(tempFilePath);
                  }
                });
              }
            });
          }
        };
      })(this));
    };

    FileView.prototype.select = function() {
      this.closest('.archive-editor').find('.selected').toggleClass('selected');
      this.addClass('selected');
      return this.focus();
    };

    return FileView;

  })(View);

}).call(this);
