(function() {
  var ArchiveEditor, path;

  path = require('path');

  ArchiveEditor = require('../lib/archive-editor');

  describe("ArchiveEditor", function() {
    return describe(".deserialize", function() {
      return it("returns undefined if no file exists at the given path", function() {
        var editor, state;
        spyOn(console, 'warn');
        editor = new ArchiveEditor({
          path: path.join(__dirname, 'fixtures', 'nested.tar')
        });
        state = editor.serialize();
        expect(ArchiveEditor.deserialize(state)).toBeDefined();
        state.path = 'bogus';
        return expect(ArchiveEditor.deserialize(state)).toBeUndefined();
      });
    });
  });

}).call(this);
