(function() {
  var $, Disposable, File, fs;

  fs = require('fs-plus');

  Disposable = require('atom').Disposable;

  File = require('pathwatcher').File;

  $ = require('atom-space-pen-views').$;

  describe("Archive viewer", function() {
    var archiveView, onDidChangeCallback, onDidDeleteCallback, _ref;
    _ref = [], archiveView = _ref[0], onDidDeleteCallback = _ref[1], onDidChangeCallback = _ref[2];
    beforeEach(function() {
      spyOn(File.prototype, 'onDidDelete').andCallFake(function(callback) {
        if (this.getPath().match(/\.tar$/)) {
          onDidDeleteCallback = callback;
        }
        return new Disposable;
      });
      spyOn(File.prototype, 'onDidChange').andCallFake(function(callback) {
        if (this.getPath().match(/\.tar$/)) {
          onDidChangeCallback = callback;
        }
        return new Disposable;
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('archive-view');
      });
      waitsForPromise(function() {
        return atom.workspace.open('nested.tar');
      });
      return runs(function() {
        return archiveView = $(atom.views.getView(atom.workspace.getActivePaneItem())).view();
      });
    });
    describe(".initialize()", function() {
      it("displays the files and folders in the archive file", function() {
        expect(archiveView).toExist();
        waitsFor(function() {
          return archiveView.find('.entry').length > 0;
        });
        return runs(function() {
          expect(archiveView.find('.directory').length).toBe(6);
          expect(archiveView.find('.directory:eq(0)').text()).toBe('d1');
          expect(archiveView.find('.directory:eq(1)').text()).toBe('d2');
          expect(archiveView.find('.directory:eq(2)').text()).toBe('d3');
          expect(archiveView.find('.directory:eq(3)').text()).toBe('d4');
          expect(archiveView.find('.directory:eq(4)').text()).toBe('da');
          expect(archiveView.find('.directory:eq(5)').text()).toBe('db');
          expect(archiveView.find('.file').length).toBe(3);
          expect(archiveView.find('.file:eq(0)').text()).toBe('f1.txt');
          expect(archiveView.find('.file:eq(1)').text()).toBe('f2.txt');
          return expect(archiveView.find('.file:eq(2)').text()).toBe('fa.txt');
        });
      });
      return it("selects the first file", function() {
        waitsFor(function() {
          return archiveView.find('.entry').length > 0;
        });
        return runs(function() {
          return expect(archiveView.find('.selected').text()).toBe('f1.txt');
        });
      });
    });
    describe("when core:move-up/core:move-down is triggered", function() {
      return it("selects the next/previous file", function() {
        waitsFor(function() {
          return archiveView.find('.entry').length > 0;
        });
        return runs(function() {
          atom.commands.dispatch(archiveView.find('.selected')[0], 'core:move-up');
          expect(archiveView.find('.selected').text()).toBe('f1.txt');
          atom.commands.dispatch(archiveView.find('.selected')[0], 'core:move-down');
          expect(archiveView.find('.selected').text()).toBe('f2.txt');
          atom.commands.dispatch(archiveView.find('.selected')[0], 'core:move-down');
          expect(archiveView.find('.selected').text()).toBe('fa.txt');
          atom.commands.dispatch(archiveView.find('.selected')[0], 'core:move-down');
          expect(archiveView.find('.selected').text()).toBe('fa.txt');
          atom.commands.dispatch(archiveView.find('.selected')[0], 'core:move-up');
          expect(archiveView.find('.selected').text()).toBe('f2.txt');
          atom.commands.dispatch(archiveView.find('.selected')[0], 'core:move-up');
          return expect(archiveView.find('.selected').text()).toBe('f1.txt');
        });
      });
    });
    describe("when a file is clicked", function() {
      return it("copies the contents to a temp file and opens it in a new editor", function() {
        waitsFor(function() {
          return archiveView.find('.entry').length > 0;
        });
        runs(function() {
          return archiveView.find('.file:eq(2)').trigger('click');
        });
        waitsFor(function() {
          return atom.workspace.getActivePane().getItems().length > 1;
        });
        return runs(function() {
          expect(atom.workspace.getActivePaneItem().getText()).toBe('hey there\n');
          return expect(atom.workspace.getActivePaneItem().getTitle()).toBe('fa.txt');
        });
      });
    });
    describe("when core:confirm is triggered", function() {
      return it("copies the contents to a temp file and opens it in a new editor", function() {
        waitsFor(function() {
          return archiveView.find('.entry').length > 0;
        });
        runs(function() {
          return atom.commands.dispatch(archiveView.find('.file:eq(0)')[0], 'core:confirm');
        });
        waitsFor(function() {
          return atom.workspace.getActivePane().getItems().length > 1;
        });
        return runs(function() {
          expect(atom.workspace.getActivePaneItem().getText()).toBe('');
          return expect(atom.workspace.getActivePaneItem().getTitle()).toBe('f1.txt');
        });
      });
    });
    describe("when the file is removed", function() {
      return it("destroys the view", function() {
        waitsFor(function() {
          return archiveView.find('.entry').length > 0;
        });
        return runs(function() {
          expect(atom.workspace.getActivePane().getItems().length).toBe(1);
          onDidDeleteCallback();
          return expect(atom.workspace.getActivePaneItem()).toBeUndefined();
        });
      });
    });
    describe("when the file is modified", function() {
      return it("refreshes the view", function() {
        waitsFor(function() {
          return archiveView.find('.entry').length > 0;
        });
        return runs(function() {
          spyOn(archiveView, 'refresh');
          onDidChangeCallback();
          return expect(archiveView.refresh).toHaveBeenCalled();
        });
      });
    });
    return describe("when the file is invalid", function() {
      beforeEach(function() {
        waitsForPromise(function() {
          return atom.workspace.open('invalid.zip');
        });
        return runs(function() {
          archiveView = $(atom.views.getView(atom.workspace.getActivePaneItem())).view();
          return jasmine.attachToDOM(atom.views.getView(atom.workspace));
        });
      });
      return it("shows the error", function() {
        waitsFor(function() {
          return archiveView.errorMessage.isVisible();
        });
        return runs(function() {
          return expect(archiveView.errorMessage.text().length).toBeGreaterThan(0);
        });
      });
    });
  });

}).call(this);
