(function() {
  var Emitter, KeyboardLayoutObserver, emitter, getCurrentKeyboardLayout, observeCurrentKeyboardLayout, observer, onDidChangeCurrentKeyboardLayout;

  Emitter = require('event-kit').Emitter;

  KeyboardLayoutObserver = require('../build/Release/keyboard-layout-observer.node').KeyboardLayoutObserver;

  emitter = new Emitter;

  observer = new KeyboardLayoutObserver(function() {
    return emitter.emit('did-change-current-keyboard-layout', getCurrentKeyboardLayout());
  });

  getCurrentKeyboardLayout = function() {
    return observer.getCurrentKeyboardLayout();
  };

  onDidChangeCurrentKeyboardLayout = function(callback) {
    return emitter.on('did-change-current-keyboard-layout', callback);
  };

  observeCurrentKeyboardLayout = function(callback) {
    callback(getCurrentKeyboardLayout());
    return onDidChangeCurrentKeyboardLayout(callback);
  };

  module.exports = {
    getCurrentKeyboardLayout: getCurrentKeyboardLayout,
    onDidChangeCurrentKeyboardLayout: onDidChangeCurrentKeyboardLayout,
    observeCurrentKeyboardLayout: observeCurrentKeyboardLayout
  };

}).call(this);
