(function() {
  module.exports = {
    activate: function() {
      return atom.commands.add('atom-text-editor', {
        'autoflow:reflow-selection': (function(_this) {
          return function(event) {
            return _this.reflowSelection(event.currentTarget.getModel());
          };
        })(this)
      });
    },
    reflowSelection: function(editor) {
      var range, reflowOptions, reflowedText;
      range = editor.getSelectedBufferRange();
      if (range.isEmpty()) {
        range = editor.getCurrentParagraphBufferRange();
      }
      if (range == null) {
        return;
      }
      reflowOptions = {
        wrapColumn: this.getPreferredLineLength(editor)
      };
      reflowedText = this.reflow(editor.getTextInRange(range), reflowOptions);
      return editor.getBuffer().setTextInRange(range, reflowedText);
    },
    reflow: function(text, _arg) {
      var block, blockLine, blockLines, currentLine, currentLineLength, linePrefix, lines, paragraphBlocks, paragraphs, segment, wrapColumn, _i, _j, _len, _len1, _ref;
      wrapColumn = _arg.wrapColumn;
      paragraphs = [];
      paragraphBlocks = text.split(/\n\s*\n/g);
      for (_i = 0, _len = paragraphBlocks.length; _i < _len; _i++) {
        block = paragraphBlocks[_i];
        linePrefix = block.match(/^\s*[\/#*-]*\s*/g)[0];
        blockLines = block.split('\n');
        if (linePrefix) {
          blockLines = (function() {
            var _j, _len1, _results;
            _results = [];
            for (_j = 0, _len1 = blockLines.length; _j < _len1; _j++) {
              blockLine = blockLines[_j];
              _results.push(blockLine.replace(new RegExp('^' + linePrefix.replace('*', '\\*')), ''));
            }
            return _results;
          })();
        }
        lines = [];
        currentLine = [];
        currentLineLength = linePrefix.length;
        _ref = this.segmentText(blockLines.join(' '));
        for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
          segment = _ref[_j];
          if (this.wrapSegment(segment, currentLineLength, wrapColumn)) {
            lines.push(linePrefix + currentLine.join(''));
            currentLine = [];
            currentLineLength = linePrefix.length;
          }
          currentLine.push(segment);
          currentLineLength += segment.length;
        }
        lines.push(linePrefix + currentLine.join(''));
        paragraphs.push(lines.join('\n').replace(/\s+\n/g, '\n'));
      }
      return paragraphs.join('\n\n');
    },
    getPreferredLineLength: function(editor) {
      return atom.config.get('editor.preferredLineLength', {
        scope: editor.getRootScopeDescriptor()
      });
    },
    wrapSegment: function(segment, currentLineLength, wrapColumn) {
      return /\w/.test(segment) && (currentLineLength + segment.length > wrapColumn) && (currentLineLength > 0 || segment.length < wrapColumn);
    },
    segmentText: function(text) {
      var match, re, segments;
      segments = [];
      re = /[\s]+|[^\s]+/g;
      while (match = re.exec(text)) {
        segments.push(match[0]);
      }
      return segments;
    }
  };

}).call(this);
