(function() {
  var Autosave;

  Autosave = require('../lib/autosave');

  describe("Autosave", function() {
    var initialActiveItem, otherItem1, otherItem2, workspaceElement, _ref;
    _ref = [], workspaceElement = _ref[0], initialActiveItem = _ref[1], otherItem1 = _ref[2], otherItem2 = _ref[3];
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      jasmine.attachToDOM(workspaceElement);
      waitsForPromise(function() {
        return atom.packages.activatePackage("autosave");
      });
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      runs(function() {
        return initialActiveItem = atom.workspace.getActiveTextEditor();
      });
      waitsForPromise(function() {
        return atom.project.open('sample.coffee').then(function(o) {
          otherItem1 = o;
          return otherItem2 = otherItem1.copy();
        });
      });
      return runs(function() {
        spyOn(initialActiveItem, 'save');
        spyOn(otherItem1, 'save');
        return spyOn(otherItem2, 'save');
      });
    });
    describe("when the item is not modified", function() {
      return it("does not autosave the item", function() {
        atom.config.set('autosave.enabled', true);
        atom.workspace.getActivePane().splitRight({
          items: [otherItem1]
        });
        return expect(initialActiveItem.save).not.toHaveBeenCalled();
      });
    });
    describe("when the buffer is modified", function() {
      beforeEach(function() {
        return initialActiveItem.setText("i am modified");
      });
      describe("when a pane loses focus", function() {
        it("saves the item if autosave is enabled and the item has a uri", function() {
          document.body.focus();
          expect(initialActiveItem.save).not.toHaveBeenCalled();
          workspaceElement.focus();
          atom.config.set('autosave.enabled', true);
          document.body.focus();
          return expect(initialActiveItem.save).toHaveBeenCalled();
        });
        return it("suppresses autosave if the focused element is contained by the editor, such as occurs when opening the autocomplete menu", function() {
          var focusStealer, textEditorElement;
          atom.config.set('autosave.enabled', true);
          focusStealer = document.createElement('div');
          focusStealer.setAttribute('tabindex', -1);
          textEditorElement = atom.views.getView(atom.workspace.getActiveTextEditor());
          textEditorElement.appendChild(focusStealer);
          focusStealer.focus();
          return expect(initialActiveItem.save).not.toHaveBeenCalled();
        });
      });
      describe("when a new pane is created", function() {
        return it("saves the item if autosave is enabled and the item has a uri", function() {
          var leftPane, rightPane;
          leftPane = atom.workspace.getActivePane();
          rightPane = leftPane.splitRight();
          expect(initialActiveItem.save).not.toHaveBeenCalled();
          rightPane.destroy();
          leftPane.activate();
          atom.config.set('autosave.enabled', true);
          leftPane.splitRight();
          return expect(initialActiveItem.save).toHaveBeenCalled();
        });
      });
      describe("when an item is destroyed", function() {
        describe("when the item is the active item", function() {
          return it("does not save the item if autosave is enabled and the item has a uri", function() {
            var leftPane, rightPane;
            leftPane = atom.workspace.getActivePane();
            rightPane = leftPane.splitRight({
              items: [otherItem1]
            });
            leftPane.activate();
            expect(initialActiveItem).toBe(atom.workspace.getActivePaneItem());
            leftPane.destroyItem(initialActiveItem);
            expect(initialActiveItem.save).not.toHaveBeenCalled();
            otherItem2.setText("I am also modified");
            atom.config.set("autosave.enabled", true);
            leftPane = rightPane.splitLeft({
              items: [otherItem2]
            });
            expect(otherItem2).toBe(atom.workspace.getActivePaneItem());
            leftPane.destroyItem(otherItem2);
            return expect(otherItem2.save).toHaveBeenCalled();
          });
        });
        return describe("when the item is NOT the active item", function() {
          return it("does not save the item if autosave is enabled and the item has a uri", function() {
            var leftPane, rightPane;
            leftPane = atom.workspace.getActivePane();
            rightPane = leftPane.splitRight({
              items: [otherItem1]
            });
            expect(initialActiveItem).not.toBe(atom.workspace.getActivePaneItem());
            leftPane.destroyItem(initialActiveItem);
            expect(initialActiveItem.save).not.toHaveBeenCalled();
            otherItem2.setText("I am also modified");
            atom.config.set("autosave.enabled", true);
            leftPane = rightPane.splitLeft({
              items: [otherItem2]
            });
            rightPane.focus();
            expect(otherItem2).not.toBe(atom.workspace.getActivePaneItem());
            leftPane.destroyItem(otherItem2);
            return expect(otherItem2.save).toHaveBeenCalled();
          });
        });
      });
      return describe("when the item does not have a URI", function() {
        return it("does not save the item", function() {
          waitsForPromise(function() {
            return atom.workspace.open();
          });
          return runs(function() {
            var pathLessItem;
            pathLessItem = atom.workspace.getActiveTextEditor();
            spyOn(pathLessItem, 'save').andCallThrough();
            pathLessItem.setText('text!');
            expect(pathLessItem.getURI()).toBeFalsy();
            atom.config.set('autosave.enabled', true);
            atom.workspace.getActivePane().destroyItem(pathLessItem);
            return expect(pathLessItem.save).not.toHaveBeenCalled();
          });
        });
      });
    });
    return describe("when the window is blurred", function() {
      return it("saves all items", function() {
        var leftPane, rightPane;
        atom.config.set('autosave.enabled', true);
        leftPane = atom.workspace.getActivePane();
        rightPane = leftPane.splitRight({
          items: [otherItem1]
        });
        initialActiveItem.insertText('a');
        otherItem1.insertText('b');
        window.dispatchEvent(new FocusEvent('blur'));
        expect(initialActiveItem.save).toHaveBeenCalled();
        return expect(otherItem1.save).toHaveBeenCalled();
      });
    });
  });

}).call(this);
