"use strict";

var _interopRequireWildcard = function (obj) { return obj && obj.__esModule ? obj : { "default": obj }; };

var _classCallCheck = function (instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } };

var util = _interopRequireWildcard(require("../../util"));

var Logger = (function () {
  function Logger(file, filename) {
    _classCallCheck(this, Logger);

    this.filename = filename;
    this.file = file;
  }

  Logger.prototype._buildMessage = function _buildMessage(msg) {
    var parts = this.filename;
    if (msg) parts += ": " + msg;
    return parts;
  };

  Logger.prototype.error = function error(msg) {
    var Constructor = arguments[1] === undefined ? Error : arguments[1];

    throw new Constructor(this._buildMessage(msg));
  };

  Logger.prototype.deprecate = function deprecate(msg) {
    if (!this.file.opts.suppressDeprecationMessages) {
      console.error(msg);
    }
  };

  Logger.prototype.debug = function debug(msg) {
    util.debug(this._buildMessage(msg));
  };

  Logger.prototype.deopt = function deopt(node, msg) {
    util.debug(this._buildMessage(msg));
  };

  return Logger;
})();

module.exports = Logger;