(function() {
  var BackgroundTipsElement, CompositeDisposable, Template, Tips, _,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  CompositeDisposable = require('atom').CompositeDisposable;

  Tips = require('./tips');

  Template = "<ul class=\"centered background-message\">\n  <li class=\"message\"></li>\n</ul>";

  module.exports = BackgroundTipsElement = (function(_super) {
    __extends(BackgroundTipsElement, _super);

    function BackgroundTipsElement() {
      return BackgroundTipsElement.__super__.constructor.apply(this, arguments);
    }

    BackgroundTipsElement.prototype.StartDelay = 1000;

    BackgroundTipsElement.prototype.DisplayDuration = 10000;

    BackgroundTipsElement.prototype.FadeDuration = 300;

    BackgroundTipsElement.prototype.createdCallback = function() {
      this.index = -1;
      this.disposables = new CompositeDisposable;
      this.disposables.add(atom.workspace.onDidAddPane((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.disposables.add(atom.workspace.onDidDestroyPane((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      this.disposables.add(atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.updateVisibility();
        };
      })(this)));
      return this.startTimeout = setTimeout(((function(_this) {
        return function() {
          return _this.start();
        };
      })(this)), this.StartDelay);
    };

    BackgroundTipsElement.prototype.attachedCallback = function() {
      this.innerHTML = Template;
      return this.message = this.querySelector('.message');
    };

    BackgroundTipsElement.prototype.destroy = function() {
      this.stop();
      this.disposables.dispose();
      return this.destroyed = true;
    };

    BackgroundTipsElement.prototype.attach = function() {
      var paneView, top, _ref, _ref1;
      paneView = atom.views.getView(atom.workspace.getActivePane());
      top = (_ref = (_ref1 = paneView.querySelector('.item-views')) != null ? _ref1.offsetTop : void 0) != null ? _ref : 0;
      this.style.top = top + 'px';
      return paneView.appendChild(this);
    };

    BackgroundTipsElement.prototype.detach = function() {
      return this.remove();
    };

    BackgroundTipsElement.prototype.updateVisibility = function() {
      if (this.shouldBeAttached()) {
        return this.start();
      } else {
        return this.stop();
      }
    };

    BackgroundTipsElement.prototype.shouldBeAttached = function() {
      return atom.workspace.getPanes().length === 1 && (atom.workspace.getActivePaneItem() == null);
    };

    BackgroundTipsElement.prototype.start = function() {
      if (!this.shouldBeAttached() || (this.interval != null)) {
        return;
      }
      this.renderTips();
      this.randomizeIndex();
      this.attach();
      this.showNextTip();
      return this.interval = setInterval(((function(_this) {
        return function() {
          return _this.showNextTip();
        };
      })(this)), this.DisplayDuration);
    };

    BackgroundTipsElement.prototype.stop = function() {
      this.remove();
      if (this.interval != null) {
        clearInterval(this.interval);
      }
      clearTimeout(this.startTimeout);
      clearTimeout(this.nextTipTimeout);
      return this.interval = null;
    };

    BackgroundTipsElement.prototype.randomizeIndex = function() {
      var len;
      len = Tips.length;
      return this.index = Math.round(Math.random() * len) % len;
    };

    BackgroundTipsElement.prototype.showNextTip = function() {
      this.index = ++this.index % Tips.length;
      this.message.classList.remove('fade-in');
      return this.nextTipTimeout = setTimeout((function(_this) {
        return function() {
          _this.message.innerHTML = Tips[_this.index];
          _this.message.classList.remove('fade-out');
          return _this.message.classList.add('fade-in');
        };
      })(this), this.FadeDuration);
    };

    BackgroundTipsElement.prototype.renderTips = function() {
      var i, tip, _i, _len;
      if (this.tipsRendered) {
        return;
      }
      for (i = _i = 0, _len = Tips.length; _i < _len; i = ++_i) {
        tip = Tips[i];
        Tips[i] = this.renderTip(tip);
      }
      return this.tipsRendered = true;
    };

    BackgroundTipsElement.prototype.renderTip = function(str) {
      str = str.replace(/\{(.+)\}/g, (function(_this) {
        return function(match, command) {
          var binding, bindings, keystrokeLabel, scope, scopeAndCommand, _i, _len;
          scopeAndCommand = command.split('>');
          if (scopeAndCommand.length > 1) {
            scope = scopeAndCommand[0], command = scopeAndCommand[1];
          }
          bindings = atom.keymaps.findKeyBindings({
            command: command.trim()
          });
          if (scope) {
            for (_i = 0, _len = bindings.length; _i < _len; _i++) {
              binding = bindings[_i];
              if (binding.selector === scope) {
                break;
              }
            }
          } else {
            binding = _this.getKeyBindingForCurrentPlatform(bindings);
          }
          if (binding != null ? binding.keystrokes : void 0) {
            keystrokeLabel = _.humanizeKeystroke(binding.keystrokes).replace(/\s+/g, '&nbsp;');
            return "<span class=\"keystroke\">" + keystrokeLabel + "</span>";
          } else {
            return command;
          }
        };
      })(this));
      return str;
    };

    BackgroundTipsElement.prototype.getKeyBindingForCurrentPlatform = function(bindings) {
      var binding, _i, _len;
      if (!(bindings != null ? bindings.length : void 0)) {
        return;
      }
      for (_i = 0, _len = bindings.length; _i < _len; _i++) {
        binding = bindings[_i];
        if (binding.selector.indexOf(process.platform) !== -1) {
          return binding;
        }
      }
      return bindings[0];
    };

    return BackgroundTipsElement;

  })(HTMLElement);

  module.exports = document.registerElement('background-tips', {
    prototype: BackgroundTipsElement.prototype
  });

}).call(this);
