(function() {
  var BackgroundTipsView;

  BackgroundTipsView = require('../lib/background-tips-view');

  describe("BackgroundTips", function() {
    var activatePackage, backgroundTips, backgroundTipsView, workspaceElement, _ref;
    _ref = [], workspaceElement = _ref[0], backgroundTips = _ref[1], backgroundTipsView = _ref[2];
    BackgroundTipsView.prototype.DisplayDuration = 5;
    BackgroundTipsView.prototype.FadeDuration = 1;
    activatePackage = function(callback) {
      waitsForPromise(function() {
        return atom.packages.activatePackage('background-tips').then(function(_arg) {
          var mainModule;
          mainModule = _arg.mainModule;
          return backgroundTipsView = mainModule.backgroundTipsView, mainModule;
        });
      });
      return runs(function() {
        return callback();
      });
    };
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      return jasmine.attachToDOM(workspaceElement);
    });
    describe("when the package is activated when there is only one pane", function() {
      beforeEach(function() {
        return expect(atom.workspace.getPanes().length).toBe(1);
      });
      describe("when the pane is empty", function() {
        return it("attaches the view after a delay", function() {
          expect(atom.workspace.getActivePane().getItems().length).toBe(0);
          return activatePackage(function() {
            expect(backgroundTipsView.parentNode).toBeFalsy();
            advanceClock(BackgroundTipsView.prototype.StartDelay + 1);
            return expect(backgroundTipsView.parentNode).toBeTruthy();
          });
        });
      });
      describe("when the pane is not empty", function() {
        return it("does not attach the view", function() {
          waitsForPromise(function() {
            return atom.workspace.open();
          });
          return activatePackage(function() {
            advanceClock(BackgroundTipsView.prototype.StartDelay + 1);
            return expect(backgroundTipsView.parentNode).toBeFalsy();
          });
        });
      });
      return describe("when a second pane is created", function() {
        return it("detaches the view", function() {
          return activatePackage(function() {
            advanceClock(BackgroundTipsView.prototype.StartDelay + 1);
            expect(backgroundTipsView.parentNode).toBeTruthy();
            atom.workspace.getActivePane().splitRight();
            return expect(backgroundTipsView.parentNode).toBeFalsy();
          });
        });
      });
    });
    describe("when the package is activated when there are multiple panes", function() {
      beforeEach(function() {
        atom.workspace.getActivePane().splitRight();
        return expect(atom.workspace.getPanes().length).toBe(2);
      });
      it("does not attach the view", function() {
        return activatePackage(function() {
          advanceClock(BackgroundTipsView.prototype.StartDelay + 1);
          return expect(backgroundTipsView.parentNode).toBeFalsy();
        });
      });
      return describe("when all but the last pane is destroyed", function() {
        return it("attaches the view", function() {
          return activatePackage(function() {
            atom.workspace.getActivePane().destroy();
            advanceClock(BackgroundTipsView.prototype.StartDelay + 1);
            expect(backgroundTipsView.parentNode).toBeTruthy();
            atom.workspace.getActivePane().splitRight();
            expect(backgroundTipsView.parentNode).toBeFalsy();
            atom.workspace.getActivePane().destroy();
            return expect(backgroundTipsView.parentNode).toBeTruthy();
          });
        });
      });
    });
    return describe("when the view is attached", function() {
      beforeEach(function() {
        expect(atom.workspace.getPanes().length).toBe(1);
        return activatePackage(function() {
          advanceClock(BackgroundTipsView.prototype.StartDelay);
          return advanceClock(BackgroundTipsView.prototype.FadeDuration);
        });
      });
      it("has text in the message", function() {
        expect(backgroundTipsView.parentNode).toBeTruthy();
        return expect(backgroundTipsView.message.textContent).toBeTruthy();
      });
      return it("changes text in the message", function() {
        var oldText;
        oldText = backgroundTipsView.message.textContent;
        waits(BackgroundTipsView.prototype.DisplayDuration + BackgroundTipsView.prototype.FadeDuration);
        return runs(function() {
          advanceClock(BackgroundTipsView.prototype.FadeDuration);
          return expect(backgroundTipsView.message.textContent).not.toEqual(oldText);
        });
      });
    });
  });

}).call(this);
