(function() {
  var $$, BookmarksView, SelectListView, path, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  path = require('path');

  _ref = require('atom-space-pen-views'), $$ = _ref.$$, SelectListView = _ref.SelectListView;

  module.exports = BookmarksView = (function(_super) {
    __extends(BookmarksView, _super);

    function BookmarksView() {
      return BookmarksView.__super__.constructor.apply(this, arguments);
    }

    BookmarksView.prototype.initialize = function() {
      BookmarksView.__super__.initialize.apply(this, arguments);
      return this.addClass('bookmarks-view');
    };

    BookmarksView.prototype.getFilterKey = function() {
      return 'filterText';
    };

    BookmarksView.prototype.attached = function() {
      return this.focusFilterEditor();
    };

    BookmarksView.prototype.show = function() {
      this.storeFocusedElement();
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({
          item: this
        });
      }
      return this.panel.show();
    };

    BookmarksView.prototype.hide = function() {
      return this.panel.hide();
    };

    BookmarksView.prototype.cancelled = function() {
      return this.hide();
    };

    BookmarksView.prototype.toggle = function() {
      if (this.isVisible()) {
        return this.hide();
      } else {
        this.populateBookmarks();
        return this.show();
      }
    };

    BookmarksView.prototype.getFilterText = function(bookmark) {
      var bookmarkRow, bufferPath, lineText, segments;
      segments = [];
      bookmarkRow = bookmark.marker.getStartPosition().row;
      segments.push(bookmarkRow);
      if (bufferPath = bookmark.buffer.getPath()) {
        segments.push(bufferPath);
      }
      if (lineText = this.getLineText(bookmark)) {
        segments.push(lineText);
      }
      return segments.join(' ');
    };

    BookmarksView.prototype.getLineText = function(bookmark) {
      var _ref1;
      return (_ref1 = bookmark.buffer.lineForRow(bookmark.marker.getStartPosition().row)) != null ? _ref1.trim() : void 0;
    };

    BookmarksView.prototype.populateBookmarks = function() {
      var attributes, bookmark, bookmarks, buffer, marker, _i, _j, _len, _len1, _ref1, _ref2;
      bookmarks = [];
      attributes = {
        "class": 'bookmark'
      };
      _ref1 = atom.project.getBuffers();
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        buffer = _ref1[_i];
        _ref2 = buffer.findMarkers(attributes);
        for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
          marker = _ref2[_j];
          bookmark = {
            marker: marker,
            buffer: buffer
          };
          bookmark.fitlerText = this.getFilterText(bookmark);
          bookmarks.push(bookmark);
        }
      }
      return this.setItems(bookmarks);
    };

    BookmarksView.prototype.viewForItem = function(bookmark) {
      var bookmarkLocation, bookmarkRow, filePath, lineText;
      bookmarkRow = bookmark.marker.getStartPosition().row;
      if (filePath = bookmark.buffer.getPath()) {
        bookmarkLocation = "" + (path.basename(filePath)) + ":" + (bookmarkRow + 1);
      } else {
        bookmarkLocation = "untitled:" + (bookmarkRow + 1);
      }
      lineText = this.getLineText(bookmark);
      return $$(function() {
        if (lineText) {
          return this.li({
            "class": 'bookmark two-lines'
          }, (function(_this) {
            return function() {
              _this.div(bookmarkLocation, {
                "class": 'primary-line'
              });
              return _this.div(lineText, {
                "class": 'secondary-line line-text'
              });
            };
          })(this));
        } else {
          return this.li({
            "class": 'bookmark'
          }, (function(_this) {
            return function() {
              return _this.div(bookmarkLocation, {
                "class": 'primary-line'
              });
            };
          })(this));
        }
      });
    };

    BookmarksView.prototype.getEmptyMessage = function(itemCount) {
      if (itemCount === 0) {
        return 'No bookmarks found';
      } else {
        return BookmarksView.__super__.getEmptyMessage.apply(this, arguments);
      }
    };

    BookmarksView.prototype.confirmed = function(_arg) {
      var buffer, marker;
      buffer = _arg.buffer, marker = _arg.marker;
      atom.workspace.open(buffer.getPath()).done(function(editor) {
        return typeof editor.setSelectedBufferRange === "function" ? editor.setSelectedBufferRange(marker.getRange(), {
          autoscroll: true
        }) : void 0;
      });
      return this.cancel();
    };

    return BookmarksView;

  })(SelectListView);

}).call(this);
