(function() {
  var Bookmarks, BookmarksView, ReactBookmarks;

  Bookmarks = null;

  ReactBookmarks = null;

  BookmarksView = null;

  module.exports = {
    activate: function() {
      var bookmarksView;
      bookmarksView = null;
      atom.commands.add('atom-workspace', 'bookmarks:view-all', (function(_this) {
        return function() {
          if (typeof bookmarksList === "undefined" || bookmarksList === null) {
            if (BookmarksView == null) {
              BookmarksView = require('./bookmarks-view');
            }
            bookmarksView = new BookmarksView();
          }
          return bookmarksView.toggle();
        };
      })(this));
      return atom.workspace.observeTextEditors((function(_this) {
        return function(textEditor) {
          var bookmarks;
          if (Bookmarks == null) {
            Bookmarks = require('./bookmarks');
          }
          return bookmarks = new Bookmarks(textEditor);
        };
      })(this));
    }
  };

}).call(this);
