(function() {
  var $;

  $ = require('atom-space-pen-views').$;

  describe("Bookmarks package", function() {
    var editor, editorElement, workspaceElement, _ref;
    _ref = [], workspaceElement = _ref[0], editorElement = _ref[1], editor = _ref[2], editor = _ref[3];
    beforeEach(function() {
      spyOn(window, 'setImmediate').andCallFake(function(fn) {
        return fn();
      });
      workspaceElement = atom.views.getView(atom.workspace);
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('bookmarks');
      });
      return runs(function() {
        jasmine.attachToDOM(workspaceElement);
        editor = atom.workspace.getActiveTextEditor();
        editorElement = atom.views.getView(editor);
        return spyOn(atom, 'beep');
      });
    });
    describe("toggling bookmarks", function() {
      it("creates a marker when toggled", function() {
        var markers;
        editor.setCursorBufferPosition([3, 10]);
        expect(editor.findMarkers({
          "class": 'bookmark'
        }).length).toEqual(0);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        markers = editor.findMarkers({
          "class": 'bookmark'
        });
        expect(markers.length).toEqual(1);
        return expect(markers[0].getBufferRange()).toEqual([[3, 0], [3, 0]]);
      });
      it("removes marker when toggled", function() {
        editor.setCursorBufferPosition([3, 10]);
        expect(editor.findMarkers({
          "class": 'bookmark'
        }).length).toEqual(0);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        expect(editor.findMarkers({
          "class": 'bookmark'
        }).length).toEqual(1);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        return expect(editor.findMarkers({
          "class": 'bookmark'
        }).length).toEqual(0);
      });
      it("toggles proper classes on proper gutter row", function() {
        var lines;
        editor.setCursorBufferPosition([3, 10]);
        expect(editorElement.shadowRoot.querySelectorAll('.bookmarked').length).toBe(0);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        lines = editorElement.shadowRoot.querySelectorAll('.bookmarked');
        expect(lines.length).toEqual(1);
        expect(lines[0]).toHaveClass('line-number-3');
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        return expect(editorElement.shadowRoot.querySelectorAll('.bookmarked').length).toBe(0);
      });
      return it("clears all bookmarks", function() {
        editor.setCursorBufferPosition([3, 10]);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        editor.setCursorBufferPosition([5, 0]);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        atom.commands.dispatch(editorElement, 'bookmarks:clear-bookmarks');
        expect(editorElement.shadowRoot.querySelectorAll('.bookmarked').length).toBe(0);
        return expect(editor.findMarkers({
          "class": 'bookmark'
        })).toHaveLength(0);
      });
    });
    describe("when a bookmark is invalidated", function() {
      return it("creates a marker when toggled", function() {
        var markers;
        editor.setCursorBufferPosition([3, 10]);
        expect(editor.findMarkers({
          "class": 'bookmark'
        }).length).toEqual(0);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        markers = editor.findMarkers({
          "class": 'bookmark'
        });
        expect(markers.length).toEqual(1);
        editor.setText('');
        markers = editor.findMarkers({
          "class": 'bookmark'
        });
        return expect(markers.length).toEqual(0);
      });
    });
    describe("jumping between bookmarks", function() {
      it("doesnt die when no bookmarks", function() {
        editor.setCursorBufferPosition([5, 10]);
        atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
        expect(editor.getLastCursor().getBufferPosition()).toEqual([5, 10]);
        expect(atom.beep.callCount).toBe(1);
        atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
        expect(editor.getLastCursor().getBufferPosition()).toEqual([5, 10]);
        return expect(atom.beep.callCount).toBe(2);
      });
      describe("with one bookmark", function() {
        beforeEach(function() {
          editor.setCursorBufferPosition([2, 0]);
          return atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        });
        it("jump-to-next-bookmark jumps to the right place", function() {
          editor.setCursorBufferPosition([0, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
          editor.setCursorBufferPosition([5, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
          return expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
        });
        return it("jump-to-previous-bookmark jumps to the right place", function() {
          editor.setCursorBufferPosition([0, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
          editor.setCursorBufferPosition([5, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
          return expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
        });
      });
      return describe("with bookmarks", function() {
        beforeEach(function() {
          editor.setCursorBufferPosition([2, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
          editor.setCursorBufferPosition([10, 0]);
          return atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        });
        it("jump-to-next-bookmark finds next bookmark", function() {
          editor.setCursorBufferPosition([0, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([10, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
          editor.setCursorBufferPosition([11, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-next-bookmark');
          return expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
        });
        return it("jump-to-previous-bookmark finds previous bookmark", function() {
          editor.setCursorBufferPosition([0, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([10, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([2, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
          expect(editor.getLastCursor().getBufferPosition()).toEqual([10, 0]);
          editor.setCursorBufferPosition([11, 0]);
          atom.commands.dispatch(editorElement, 'bookmarks:jump-to-previous-bookmark');
          return expect(editor.getLastCursor().getBufferPosition()).toEqual([10, 0]);
        });
      });
    });
    return describe("browsing bookmarks", function() {
      it("displays a select list of all bookmarks", function() {
        var bookmarks;
        editor.setCursorBufferPosition([0]);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        editor.setCursorBufferPosition([2]);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        editor.setCursorBufferPosition([4]);
        atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
        atom.commands.dispatch(workspaceElement, 'bookmarks:view-all');
        bookmarks = $(workspaceElement).find('.bookmarks-view');
        expect(bookmarks).toExist();
        expect(bookmarks.find('.bookmark').length).toBe(3);
        expect(bookmarks.find('.bookmark:eq(0)').find('.primary-line').text()).toBe('sample.js:1');
        expect(bookmarks.find('.bookmark:eq(0)').find('.secondary-line').text()).toBe('var quicksort = function () {');
        expect(bookmarks.find('.bookmark:eq(1)').find('.primary-line').text()).toBe('sample.js:3');
        expect(bookmarks.find('.bookmark:eq(1)').find('.secondary-line').text()).toBe('if (items.length <= 1) return items;');
        expect(bookmarks.find('.bookmark:eq(2)').find('.primary-line').text()).toBe('sample.js:5');
        return expect(bookmarks.find('.bookmark:eq(2)').find('.secondary-line').text()).toBe('while(items.length > 0) {');
      });
      return describe("when a bookmark is selected", function() {
        return it("sets the cursor to the location the bookmark", function() {
          var bookmarks;
          editor.setCursorBufferPosition([8]);
          atom.commands.dispatch(editorElement, 'bookmarks:toggle-bookmark');
          editor.setCursorBufferPosition([0]);
          atom.commands.dispatch(workspaceElement, 'bookmarks:view-all');
          bookmarks = $(workspaceElement).find('.bookmarks-view');
          expect(bookmarks).toExist();
          bookmarks.find('.bookmark').mousedown().mouseup();
          return waitsFor(function() {
            return editor.getCursorBufferPosition().isEqual([8, 0]);
          });
        });
      });
    });
  });

}).call(this);
