(function() {
  var BracketMatcher, BracketMatcherView;

  BracketMatcher = require('./bracket-matcher');

  BracketMatcherView = require('./bracket-matcher-view');

  module.exports = {
    config: {
      autocompleteBrackets: {
        type: 'boolean',
        "default": true
      },
      autocompleteSmartQuotes: {
        type: 'boolean',
        "default": true
      },
      wrapSelectionsInBrackets: {
        type: 'boolean',
        "default": true
      }
    },
    activate: function() {
      return atom.workspace.observeTextEditors(function(editor) {
        var editorElement;
        editorElement = atom.views.getView(editor);
        new BracketMatcherView(editor, editorElement);
        return new BracketMatcher(editor, editorElement);
      });
    }
  };

}).call(this);
