(function() {
  var $, $$, CommandPaletteView, SelectListView, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), SelectListView = _ref.SelectListView, $ = _ref.$, $$ = _ref.$$;

  module.exports = CommandPaletteView = (function(_super) {
    __extends(CommandPaletteView, _super);

    function CommandPaletteView() {
      return CommandPaletteView.__super__.constructor.apply(this, arguments);
    }

    CommandPaletteView.activate = function() {
      var view;
      view = new CommandPaletteView;
      return this.disposable = atom.commands.add('atom-workspace', 'command-palette:toggle', function() {
        return view.toggle();
      });
    };

    CommandPaletteView.deactivate = function() {
      return this.disposable.dispose();
    };

    CommandPaletteView.prototype.keyBindings = null;

    CommandPaletteView.prototype.initialize = function() {
      CommandPaletteView.__super__.initialize.apply(this, arguments);
      return this.addClass('command-palette');
    };

    CommandPaletteView.prototype.getFilterKey = function() {
      return 'displayName';
    };

    CommandPaletteView.prototype.cancelled = function() {
      return this.hide();
    };

    CommandPaletteView.prototype.toggle = function() {
      var _ref1;
      if ((_ref1 = this.panel) != null ? _ref1.isVisible() : void 0) {
        return this.cancel();
      } else {
        return this.show();
      }
    };

    CommandPaletteView.prototype.show = function() {
      var commands;
      if (this.panel == null) {
        this.panel = atom.workspace.addModalPanel({
          item: this
        });
      }
      this.panel.show();
      this.storeFocusedElement();
      if (this.previouslyFocusedElement[0] && this.previouslyFocusedElement[0] !== document.body) {
        this.eventElement = this.previouslyFocusedElement[0];
      } else {
        this.eventElement = atom.views.getView(atom.workspace);
      }
      this.keyBindings = atom.keymaps.findKeyBindings({
        target: this.eventElement
      });
      commands = atom.commands.findCommands({
        target: this.eventElement
      });
      commands = _.sortBy(commands, 'displayName');
      this.setItems(commands);
      return this.focusFilterEditor();
    };

    CommandPaletteView.prototype.hide = function() {
      var _ref1;
      return (_ref1 = this.panel) != null ? _ref1.hide() : void 0;
    };

    CommandPaletteView.prototype.viewForItem = function(_arg) {
      var displayName, eventDescription, keyBindings, name;
      name = _arg.name, displayName = _arg.displayName, eventDescription = _arg.eventDescription;
      keyBindings = this.keyBindings;
      return $$(function() {
        return this.li({
          "class": 'event',
          'data-event-name': name
        }, (function(_this) {
          return function() {
            _this.div({
              "class": 'pull-right'
            }, function() {
              var binding, _i, _len, _results;
              _results = [];
              for (_i = 0, _len = keyBindings.length; _i < _len; _i++) {
                binding = keyBindings[_i];
                if (binding.command === name) {
                  _results.push(_this.kbd(_.humanizeKeystroke(binding.keystrokes), {
                    "class": 'key-binding'
                  }));
                }
              }
              return _results;
            });
            return _this.span(displayName, {
              title: name
            });
          };
        })(this));
      });
    };

    CommandPaletteView.prototype.confirmed = function(_arg) {
      var name;
      name = _arg.name;
      this.cancel();
      return this.eventElement.dispatchEvent(new CustomEvent(name, {
        bubbles: true,
        cancelable: true
      }));
    };

    return CommandPaletteView;

  })(SelectListView);

}).call(this);
