(function() {
  var $, CommandPalette, _;

  _ = require('underscore-plus');

  $ = require('atom-space-pen-views').$;

  CommandPalette = require('../lib/command-palette-view');

  describe("CommandPalette", function() {
    var editorElement, expectCommandsForElement, palette, workspaceElement, _ref;
    _ref = [], palette = _ref[0], workspaceElement = _ref[1], editorElement = _ref[2];
    beforeEach(function() {
      var activationPromise;
      workspaceElement = atom.views.getView(atom.workspace);
      activationPromise = null;
      waitsForPromise(function() {
        return atom.workspace.open();
      });
      runs(function() {
        editorElement = atom.views.getView(atom.workspace.getActiveTextEditor());
        activationPromise = atom.packages.activatePackage("command-palette");
        jasmine.attachToDOM(workspaceElement);
        return atom.commands.dispatch(workspaceElement, 'command-palette:toggle');
      });
      waitsForPromise(function() {
        return activationPromise;
      });
      return runs(function() {
        return palette = $(workspaceElement.querySelector('.command-palette')).view();
      });
    });
    expectCommandsForElement = function(element) {
      var binding, displayName, eventLi, keyBindings, name, _i, _len, _ref1, _ref2, _results;
      keyBindings = atom.keymaps.findKeyBindings({
        target: element
      });
      _ref1 = atom.commands.findCommands({
        target: element
      });
      _results = [];
      for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
        _ref2 = _ref1[_i], name = _ref2.name, displayName = _ref2.displayName;
        eventLi = palette.list.children("[data-event-name='" + name + "']");
        expect(eventLi).toExist();
        expect(eventLi.find('span')).toHaveText(displayName);
        expect(eventLi.find('span').attr('title')).toBe(name);
        _results.push((function() {
          var _j, _len1, _results1;
          _results1 = [];
          for (_j = 0, _len1 = keyBindings.length; _j < _len1; _j++) {
            binding = keyBindings[_j];
            if (binding.command === name) {
              _results1.push(expect(eventLi.text()).toContain(_.humanizeKeystroke(binding.keystrokes)));
            }
          }
          return _results1;
        })());
      }
      return _results;
    };
    describe("when command-palette:toggle is triggered on the root view", function() {
      it("shows a list of all valid command descriptions, names, and keybindings for the previously focused element", function() {
        var commands, keyBindings;
        keyBindings = atom.keymaps.findKeyBindings({
          target: editorElement
        });
        commands = atom.commands.findCommands({
          target: editorElement
        });
        return expectCommandsForElement(editorElement);
      });
      it("focuses the mini-editor and selects the first command", function() {
        expect(palette.filterEditorView.hasFocus()).toBeTruthy();
        return expect(palette.find('.event:first')).toHaveClass('selected');
      });
      return it("clears the previous mini editor text", function() {
        palette.filterEditorView.setText('hello');
        atom.commands.dispatch(workspaceElement, 'command-palette:toggle');
        return expect(palette.filterEditorView.getText()).toBe('');
      });
    });
    describe("when command-palette:toggle is triggered on the open command palette", function() {
      return it("focus the root view and hides the command palette", function() {
        expect(palette.isVisible()).toBeTruthy();
        atom.commands.dispatch(palette[0], 'command-palette:toggle');
        expect(palette.is(':visible')).toBeFalsy();
        return expect(document.activeElement).toBe(editorElement);
      });
    });
    describe("when the command palette is cancelled", function() {
      return it("focuses the root view and hides the command palette", function() {
        expect(palette.is(':visible')).toBeTruthy();
        palette.cancel();
        expect(palette.is(':visible')).toBeFalsy();
        return expect(document.activeElement).toBe(editorElement);
      });
    });
    describe("when an command selection is confirmed", function() {
      return it("hides the palette, then focuses the previously focused element and emits the selected command on it", function() {
        var eventHandler, eventName;
        eventHandler = jasmine.createSpy('eventHandler').andReturn(false);
        eventName = palette.items[3].name;
        atom.commands.add(editorElement, eventName, eventHandler);
        palette.confirmed(palette.items[3]);
        expect(document.activeElement).toBe(editorElement);
        expect(eventHandler).toHaveBeenCalled();
        return expect(palette.is(':visible')).toBeFalsy();
      });
    });
    describe("when no element has focus", function() {
      return it("uses the root view as the element to display and trigger events for", function() {
        atom.commands.dispatch(workspaceElement, 'command-palette:toggle');
        document.activeElement.blur();
        atom.commands.dispatch(workspaceElement, 'command-palette:toggle');
        return expectCommandsForElement(workspaceElement);
      });
    });
    return describe("when the body has focus", function() {
      return it("uses the root view as the element to display and trigger events for", function() {
        atom.commands.dispatch(workspaceElement, 'command-palette:toggle');
        document.body.focus();
        atom.commands.dispatch(workspaceElement, 'command-palette:toggle');
        return expectCommandsForElement(workspaceElement);
      });
    });
  });

}).call(this);
