(function() {
  var $, $$, CompositeDisposable, DeprecationCopStatusBarView, Grim, View, getSelectorDeprecations, getSelectorDeprecationsCount, _, _ref, _ref1,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  CompositeDisposable = require('atom').CompositeDisposable;

  _ref = require('atom-space-pen-views'), $ = _ref.$, $$ = _ref.$$, View = _ref.View;

  _ = require('underscore-plus');

  Grim = require('grim');

  _ref1 = require('./helpers'), getSelectorDeprecations = _ref1.getSelectorDeprecations, getSelectorDeprecationsCount = _ref1.getSelectorDeprecationsCount;

  module.exports = DeprecationCopStatusBarView = (function(_super) {
    __extends(DeprecationCopStatusBarView, _super);

    function DeprecationCopStatusBarView() {
      this.update = __bind(this.update, this);
      this.updateDeprecatedSelectorCount = __bind(this.updateDeprecatedSelectorCount, this);
      return DeprecationCopStatusBarView.__super__.constructor.apply(this, arguments);
    }

    DeprecationCopStatusBarView.content = function() {
      return this.div({
        "class": 'deprecation-cop-status inline-block text-warning',
        tabindex: -1
      }, (function(_this) {
        return function() {
          _this.span({
            "class": 'icon icon-alert'
          });
          return _this.span({
            "class": 'deprecation-number',
            outlet: 'deprecationNumber'
          }, '0');
        };
      })(this));
    };

    DeprecationCopStatusBarView.prototype.lastLength = null;

    DeprecationCopStatusBarView.prototype.toolTipDisposable = null;

    DeprecationCopStatusBarView.prototype.initialize = function() {
      this.subscriptions = new CompositeDisposable;
      this.subscriptions.add(Grim.on('updated', this.update));
      this.subscriptions.add(atom.packages.onDidLoadPackage(this.updateDeprecatedSelectorCount));
      this.subscriptions.add(atom.packages.onDidUnloadPackage(this.updateDeprecatedSelectorCount));
      return this.subscriptions.add(atom.packages.onDidActivatePackage(this.updateDeprecatedSelectorCount));
    };

    DeprecationCopStatusBarView.prototype.destroy = function() {
      this.subscriptions.dispose();
      return this.detach();
    };

    DeprecationCopStatusBarView.prototype.attached = function() {
      this.update();
      return this.click(function() {
        var workspaceElement;
        workspaceElement = atom.views.getView(atom.workspace);
        return atom.commands.dispatch(workspaceElement, 'deprecation-cop:view');
      });
    };

    DeprecationCopStatusBarView.prototype.getDeprecatedSelectorCount = function() {
      return this.deprecatedSelectorCount != null ? this.deprecatedSelectorCount : this.deprecatedSelectorCount = getSelectorDeprecationsCount();
    };

    DeprecationCopStatusBarView.prototype.updateDeprecatedSelectorCount = function() {
      this.deprecatedSelectorCount = null;
      return this.update();
    };

    DeprecationCopStatusBarView.prototype.update = function() {
      var length, _ref2;
      length = Grim.getDeprecationsLength() + this.getDeprecatedSelectorCount();
      if (this.lastLength === length) {
        return;
      }
      this.lastLength = length;
      this.deprecationNumber.text(length);
      if ((_ref2 = this.toolTipDisposable) != null) {
        _ref2.dispose();
      }
      this.toolTipDisposable = atom.tooltips.add(this.element, {
        title: "" + (_.pluralize(length, 'call')) + " to deprecated methods"
      });
      if (length === 0) {
        return this.hide();
      } else {
        return this.show();
      }
    };

    return DeprecationCopStatusBarView;

  })(View);

}).call(this);
