(function() {
  var SelectorLinter;

  SelectorLinter = require('atom-selector-linter');

  exports.getSelectorDeprecations = function() {
    var linter, pkg, _i, _len, _ref;
    linter = new SelectorLinter({
      maxPerPackage: 50
    });
    _ref = atom.packages.getLoadedPackages();
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      pkg = _ref[_i];
      linter.checkPackage(pkg);
    }
    return linter.getDeprecations();
  };

  exports.getSelectorDeprecationsCount = function() {
    var count, deprecations, deprecationsByFile, deprecationsByPackageName, fileName, packageName;
    count = 0;
    deprecationsByPackageName = exports.getSelectorDeprecations();
    for (packageName in deprecationsByPackageName) {
      deprecationsByFile = deprecationsByPackageName[packageName];
      for (fileName in deprecationsByFile) {
        deprecations = deprecationsByFile[fileName];
        count += deprecations.length;
      }
    }
    return count;
  };

}).call(this);
