(function() {
  var DeprecationCopView, Grim, createView, viewUri;

  Grim = require('grim');

  DeprecationCopView = null;

  viewUri = 'atom://deprecation-cop';

  createView = function(state) {
    if (DeprecationCopView == null) {
      DeprecationCopView = require('./deprecation-cop-view');
    }
    return new DeprecationCopView(state);
  };

  if (Grim.includeDeprecatedAPIs) {
    atom.deserializers.add({
      name: 'DeprecationCopView',
      deserialize: createView
    });
  }

  module.exports = {
    deprecationCopView: null,
    deprecationCopStatusBarView: null,
    commandSubscription: null,
    activate: function() {
      if (!Grim.includeDeprecatedAPIs) {
        return;
      }
      atom.workspace.addOpener((function(_this) {
        return function(uriToOpen) {
          if (uriToOpen !== viewUri) {
            return;
          }
          return _this.deprecationCopView = createView({
            uri: uriToOpen
          });
        };
      })(this));
      return this.commandSubscription = atom.commands.add('atom-workspace', 'deprecation-cop:view', function() {
        return atom.workspace.open(viewUri);
      });
    },
    deactivate: function() {
      var _ref, _ref1, _ref2;
      if ((_ref = this.deprecationCopView) != null) {
        _ref.destroy();
      }
      if ((_ref1 = this.deprecationCopStatusBarView) != null) {
        _ref1.destroy();
      }
      if ((_ref2 = this.commandSubscription) != null) {
        _ref2.dispose();
      }
      this.deprecationCopView = null;
      this.deprecationCopStatusBarView = null;
      return this.commandSubscription = null;
    },
    consumeStatusBar: function(statusBar) {
      var DeprecationCopStatusBarView;
      if (!Grim.includeDeprecatedAPIs) {
        return;
      }
      DeprecationCopStatusBarView = require('./deprecation-cop-status-bar-view');
      if (this.deprecationCopStatusBarView == null) {
        this.deprecationCopStatusBarView = new DeprecationCopStatusBarView();
      }
      return statusBar.addRightTile({
        item: this.deprecationCopStatusBarView,
        priority: 150
      });
    }
  };

}).call(this);
