(function() {
  var DeprecationCopView;

  DeprecationCopView = require('../lib/deprecation-cop-view');

  describe("DeprecationCop", function() {
    var activationPromise, workspaceElement, _ref;
    _ref = [], activationPromise = _ref[0], workspaceElement = _ref[1];
    beforeEach(function() {
      workspaceElement = atom.views.getView(atom.workspace);
      return activationPromise = atom.packages.activatePackage('deprecation-cop');
    });
    return describe("when the deprecation-cop:view event is triggered", function() {
      return it("displayes deprecation cop pane", function() {
        expect(atom.workspace.getActivePane().getActiveItem()).not.toExist();
        atom.commands.dispatch(workspaceElement, 'deprecation-cop:view');
        waitsForPromise(function() {
          return activationPromise;
        });
        return runs(function() {
          var deprecationCopView;
          deprecationCopView = atom.workspace.getActivePane().getActiveItem();
          return expect(deprecationCopView instanceof DeprecationCopView).toBeTruthy();
        });
      });
    });
  });

}).call(this);
