(function() {
  var DeprecationCopView, Grim, path;

  path = require('path');

  Grim = require('grim');

  DeprecationCopView = require('../lib/deprecation-cop-view');

  describe("DeprecationCopStatusBarView", function() {
    var deprecatedMethod, statusBarView, workspaceElement, _ref;
    _ref = [], deprecatedMethod = _ref[0], statusBarView = _ref[1], workspaceElement = _ref[2];
    beforeEach(function() {
      jasmine.snapshotDeprecations();
      workspaceElement = atom.views.getView(atom.workspace);
      jasmine.attachToDOM(workspaceElement);
      waitsForPromise(function() {
        return atom.packages.activatePackage('status-bar');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('deprecation-cop');
      });
      return runs(function() {
        return statusBarView = workspaceElement.querySelector('.deprecation-cop-status');
      });
    });
    afterEach(function() {
      return jasmine.restoreDeprecationsSnapshot();
    });
    it("adds the status bar view when activated", function() {
      expect(statusBarView).toExist();
      expect(statusBarView.textContent).toBe('0');
      return expect(statusBarView).not.toShow();
    });
    it("increments when there are deprecated methods", function() {
      var anotherDeprecatedMethod;
      deprecatedMethod = function() {
        return Grim.deprecate("This isn't used");
      };
      anotherDeprecatedMethod = function() {
        return Grim.deprecate("This either");
      };
      expect(statusBarView.style.display).toBe('none');
      expect(statusBarView).not.toShow();
      deprecatedMethod();
      expect(statusBarView.textContent).toBe('1');
      expect(statusBarView).toShow();
      deprecatedMethod();
      expect(statusBarView.textContent).toBe('1');
      expect(statusBarView).toShow();
      anotherDeprecatedMethod();
      expect(statusBarView.textContent).toBe('2');
      return expect(statusBarView).toShow();
    });
    it("increments when there are deprecated selectors", function() {
      atom.packages.loadPackage(path.join(__dirname, "..", "spec", "fixtures", "package-with-deprecated-selectors"));
      expect(statusBarView.textContent).toBe('3');
      expect(statusBarView).toBeVisible();
      atom.packages.unloadPackage('package-with-deprecated-selectors');
      expect(statusBarView.textContent).toBe('0');
      return expect(statusBarView).not.toBeVisible();
    });
    it("increments when a theme with deprecated selectors is activated", function() {
      atom.packages.loadPackage(path.join(__dirname, "..", "spec", "fixtures", "theme-with-deprecated-selectors"));
      expect(statusBarView).not.toBeVisible();
      expect(statusBarView.textContent).toBe('0');
      waitsForPromise(function() {
        return atom.packages.activatePackage(path.join(__dirname, "..", "spec", "fixtures", "theme-with-deprecated-selectors"));
      });
      return runs(function() {
        expect(statusBarView).toBeVisible();
        return expect(statusBarView.textContent).toBe('1');
      });
    });
    return it('opens deprecation cop tab when clicked', function() {
      expect(atom.workspace.getActivePane().getActiveItem()).not.toExist();
      statusBarView.click();
      waits(0);
      return runs(function() {
        var depCopView;
        depCopView = atom.workspace.getActivePane().getActiveItem();
        return expect(depCopView instanceof DeprecationCopView).toBe(true);
      });
    });
  });

}).call(this);
