(function() {
  var DeprecationCopView, Grim, path;

  Grim = require('grim');

  DeprecationCopView = require('../lib/deprecation-cop-view');

  path = require('path');

  describe("DeprecationCopView", function() {
    var deprecationCopView, workspaceElement, _ref;
    _ref = [], deprecationCopView = _ref[0], workspaceElement = _ref[1];
    beforeEach(function() {
      var activationPromise, deprecatedMethod;
      workspaceElement = atom.views.getView(atom.workspace);
      jasmine.attachToDOM(workspaceElement);
      Grim.clearDeprecations();
      deprecatedMethod = function() {
        return Grim.deprecate("A test deprecation. This isn't used");
      };
      deprecatedMethod();
      spyOn(Grim, 'deprecate');
      activationPromise = atom.packages.activatePackage('deprecation-cop');
      atom.commands.dispatch(workspaceElement, 'deprecation-cop:view');
      waitsForPromise(function() {
        return activationPromise;
      });
      return runs(function() {
        jasmine.unspy(Grim, 'deprecate');
        return deprecationCopView = atom.workspace.getActivePane().getActiveItem();
      });
    });
    afterEach(function() {
      return Grim.clearDeprecations();
    });
    it("displays deprecated methods", function() {
      expect(deprecationCopView.html()).toMatch(/Deprecated calls/);
      return expect(deprecationCopView.html()).toMatch(/This isn't used/);
    });
    it("displays deprecated selectors", function() {
      var fakePackageDir, pack, packageDeprecationItems, packageItems;
      fakePackageDir = path.join(__dirname, "..", "spec", "fixtures", "package-with-deprecated-selectors");
      pack = atom.packages.loadPackage(fakePackageDir);
      spyOn(atom.packages, 'getLoadedPackages').andReturn([pack]);
      deprecationCopView.find("button.refresh-selectors").click();
      packageItems = deprecationCopView.find("ul.selectors > li");
      expect(packageItems.length).toBe(1);
      expect(packageItems.eq(0).html()).toMatch(/package-with-deprecated-selectors/);
      packageDeprecationItems = packageItems.eq(0).find("li.source-file");
      expect(packageDeprecationItems.length).toBe(3);
      expect(packageDeprecationItems.eq(0).text()).toMatch(/atom-text-editor/);
      expect(packageDeprecationItems.eq(0).find("a").attr("href")).toBe(path.join(fakePackageDir, "menus", "old-menu.cson"));
      expect(packageDeprecationItems.eq(1).text()).toMatch(/atom-pane-container/);
      expect(packageDeprecationItems.eq(1).find("a").attr("href")).toBe(path.join(fakePackageDir, "keymaps", "old-keymap.cson"));
      expect(packageDeprecationItems.eq(2).text()).toMatch(/atom-workspace/);
      expect(packageDeprecationItems.eq(2).find("a").attr("href")).toBe(path.join(fakePackageDir, "styles", "old-stylesheet.less"));
      return jasmine.unspy(atom.packages, 'getLoadedPackages');
    });
    return it("updates when themes with deprecated selectors are activated", function() {
      deprecationCopView.find("button.refresh-selectors").click();
      expect(deprecationCopView.find("button.refresh-selectors")).toBeHidden();
      waitsForPromise(function() {
        return atom.packages.activatePackage(path.join(__dirname, "..", "spec", "fixtures", "theme-with-deprecated-selectors"));
      });
      return runs(function() {
        return expect(deprecationCopView.find("button.refresh-selectors")).toBeVisible();
      });
    });
  });

}).call(this);
