(function() {
  var BaseThemeWatcher, Watcher, fs, path,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  fs = require('fs-plus');

  path = require('path');

  Watcher = require('./watcher');

  module.exports = BaseThemeWatcher = (function(_super) {
    __extends(BaseThemeWatcher, _super);

    function BaseThemeWatcher() {
      BaseThemeWatcher.__super__.constructor.call(this);
      this.stylesheetsPath = path.dirname(atom.themes.resolveStylesheet('../static/atom.less'));
      this.watch();
    }

    BaseThemeWatcher.prototype.watch = function() {
      var filePath, filePaths, _i, _len, _results;
      filePaths = fs.readdirSync(this.stylesheetsPath).filter(function(filePath) {
        return path.extname(filePath).indexOf('less') > -1;
      });
      _results = [];
      for (_i = 0, _len = filePaths.length; _i < _len; _i++) {
        filePath = filePaths[_i];
        _results.push(this.watchFile(path.join(this.stylesheetsPath, filePath)));
      }
      return _results;
    };

    BaseThemeWatcher.prototype.loadStylesheet = function() {
      return this.loadAllStylesheets();
    };

    BaseThemeWatcher.prototype.loadAllStylesheets = function() {
      return atom.themes.reloadBaseStylesheets();
    };

    return BaseThemeWatcher;

  })(Watcher);

}).call(this);
