(function() {
  var UIWatcher;

  UIWatcher = require('./ui-watcher');

  module.exports = {
    commandDisposable: null,
    activate: function(state) {
      var activatedDisposable, uiWatcher;
      if (!(atom.inDevMode() && !atom.inSpecMode())) {
        return;
      }
      uiWatcher = null;
      activatedDisposable = atom.packages.onDidActivateInitialPackages(function() {
        var k, packages, themes, __;
        uiWatcher = new UIWatcher({
          themeManager: atom.themes
        });
        themes = (function() {
          var _ref, _results;
          _ref = uiWatcher.watchedThemes;
          _results = [];
          for (k in _ref) {
            __ = _ref[k];
            _results.push(k);
          }
          return _results;
        })();
        packages = (function() {
          var _ref, _results;
          _ref = uiWatcher.watchedPackages;
          _results = [];
          for (k in _ref) {
            __ = _ref[k];
            _results.push(k);
          }
          return _results;
        })();
        return activatedDisposable.dispose();
      });
      return this.commandDisposable = atom.commands.add('atom-workspace', 'dev-live-reload:reload-all', function() {
        return uiWatcher.reloadAll();
      });
    },
    deactivate: function() {
      var _ref;
      return (_ref = this.commandDisposable) != null ? _ref.dispose() : void 0;
    }
  };

}).call(this);
