(function() {
  var PackageWatcher, Watcher, fs, path, _,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  fs = require('fs-plus');

  path = require('path');

  Watcher = require('./watcher');

  module.exports = PackageWatcher = (function(_super) {
    __extends(PackageWatcher, _super);

    PackageWatcher.supportsPackage = function(pack, type) {
      if (pack.getType() === type && pack.getStylesheetPaths().length) {
        return true;
      }
      return false;
    };

    function PackageWatcher(pack) {
      this.pack = pack;
      this.loadAllStylesheets = __bind(this.loadAllStylesheets, this);
      PackageWatcher.__super__.constructor.call(this);
      this.pack.onDidDeactivate(this.destroy);
      this.watch();
    }

    PackageWatcher.prototype.watch = function() {
      var onFile, onFolder, stylesheet, stylesheetPaths, stylesheetsPath, watchPath, watchedPaths, _i, _len, _ref;
      watchedPaths = [];
      watchPath = (function(_this) {
        return function(stylesheet) {
          if (!_.contains(watchedPaths, stylesheet)) {
            _this.watchFile(stylesheet);
          }
          return watchedPaths.push(stylesheet);
        };
      })(this);
      stylesheetsPath = this.pack.getStylesheetsPath();
      if (fs.isDirectorySync(stylesheetsPath)) {
        this.watchDirectory(stylesheetsPath);
      }
      stylesheetPaths = this.pack.getStylesheetPaths();
      onFile = function(stylesheetPath) {
        return stylesheetPaths.push(stylesheetPath);
      };
      onFolder = function() {
        return true;
      };
      fs.traverseTreeSync(stylesheetsPath, onFile, onFolder);
      _ref = _.uniq(stylesheetPaths);
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        stylesheet = _ref[_i];
        watchPath(stylesheet);
      }
      return this.entities;
    };

    PackageWatcher.prototype.loadStylesheet = function(pathName) {
      if (pathName.indexOf('variables') > -1) {
        this.emitGlobalsChanged();
      }
      return this.loadAllStylesheets();
    };

    PackageWatcher.prototype.loadAllStylesheets = function() {
      console.log('Reloading package', this.pack.name);
      return this.pack.reloadStylesheets();
    };

    return PackageWatcher;

  })(Watcher);

}).call(this);
