(function() {
  var BaseThemeWatcher, PackageWatcher, UIWatcher, _,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  _ = require('underscore-plus');

  BaseThemeWatcher = require('./base-theme-watcher');

  PackageWatcher = require('./package-watcher');

  module.exports = UIWatcher = (function() {
    function UIWatcher() {
      this.reloadAll = __bind(this.reloadAll, this);
      this.watchers = [];
      this.baseTheme = this.createWatcher(BaseThemeWatcher);
      this.watchPackages();
    }

    UIWatcher.prototype.watchPackages = function() {
      var pack, theme, _i, _j, _len, _len1, _ref, _ref1;
      this.watchedThemes = {};
      this.watchedPackages = {};
      _ref = atom.themes.getActiveThemes();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        theme = _ref[_i];
        this.watchTheme(theme);
      }
      _ref1 = atom.packages.getLoadedPackages();
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        pack = _ref1[_j];
        this.watchPackage(pack);
      }
      return this.watchForPackageChanges();
    };

    UIWatcher.prototype.watchForPackageChanges = function() {
      return atom.themes.onDidChangeActiveThemes((function(_this) {
        return function() {
          var k, name, theme, themes, watcher, __, _i, _len, _ref, _ref1;
          _ref = _this.watchedThemes;
          for (name in _ref) {
            watcher = _ref[name];
            watcher.destroy();
          }
          _this.watchedThemes = {};
          _ref1 = atom.themes.getActiveThemes();
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            theme = _ref1[_i];
            _this.watchTheme(theme);
          }
          themes = (function() {
            var _ref2, _results;
            _ref2 = this.watchedThemes;
            _results = [];
            for (k in _ref2) {
              __ = _ref2[k];
              _results.push(k);
            }
            return _results;
          }).call(_this);
          return null;
        };
      })(this));
    };

    UIWatcher.prototype.watchTheme = function(theme) {
      if (PackageWatcher.supportsPackage(theme, 'theme')) {
        return this.watchedThemes[theme.name] = this.createWatcher(PackageWatcher, theme);
      }
    };

    UIWatcher.prototype.watchPackage = function(pack) {
      if (PackageWatcher.supportsPackage(pack, 'atom')) {
        return this.watchedPackages[pack.name] = this.createWatcher(PackageWatcher, pack);
      }
    };

    UIWatcher.prototype.createWatcher = function(type, object) {
      var watcher;
      watcher = new type(object);
      watcher.onDidChangeGlobals((function(_this) {
        return function() {
          console.log('Global changed, reloading all styles');
          return _this.reloadAll();
        };
      })(this));
      watcher.onDidDestroy((function(_this) {
        return function() {
          return _this.watchers = _.without(_this.watchers, watcher);
        };
      })(this));
      this.watchers.push(watcher);
      return watcher;
    };

    UIWatcher.prototype.reloadAll = function() {
      var pack, _i, _j, _len, _len1, _ref, _ref1, _results;
      this.baseTheme.loadAllStylesheets();
      _ref = atom.packages.getActivePackages();
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        pack = _ref[_i];
        if (PackageWatcher.supportsPackage(pack, 'atom')) {
          pack.reloadStylesheets();
        }
      }
      _ref1 = atom.themes.getActiveThemes();
      _results = [];
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        pack = _ref1[_j];
        if (PackageWatcher.supportsPackage(pack, 'theme')) {
          _results.push(pack.reloadStylesheets());
        }
      }
      return _results;
    };

    UIWatcher.prototype.destroy = function() {
      var name, watcher, _ref, _ref1, _results;
      this.baseTheme.destroy();
      _ref = this.watchedPackages;
      for (name in _ref) {
        watcher = _ref[name];
        watcher.destroy();
      }
      _ref1 = this.watchedThemes;
      _results = [];
      for (name in _ref1) {
        watcher = _ref1[name];
        _results.push(watcher.destroy());
      }
      return _results;
    };

    return UIWatcher;

  })();

}).call(this);
