(function() {
  var CompositeDisposable, Directory, Emitter, File, Watcher, path, _ref, _ref1,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  _ref = require('pathwatcher'), File = _ref.File, Directory = _ref.Directory;

  _ref1 = require('atom'), CompositeDisposable = _ref1.CompositeDisposable, Emitter = _ref1.Emitter;

  path = require('path');

  module.exports = Watcher = (function() {
    function Watcher() {
      this.destroy = __bind(this.destroy, this);
      this.emitter = new Emitter;
      this.disposables = new CompositeDisposable;
      this.entities = [];
    }

    Watcher.prototype.onDidDestroy = function(callback) {
      return this.emitter.on('did-destroy', callback);
    };

    Watcher.prototype.onDidChangeGlobals = function(callback) {
      return this.emitter.on('did-change-globals', callback);
    };

    Watcher.prototype.destroy = function() {
      this.disposables.dispose();
      this.entities = null;
      this.emitter.emit('did-destroy');
      return this.emitter.dispose();
    };

    Watcher.prototype.watch = function() {};

    Watcher.prototype.loadStylesheet = function(stylesheetPath) {};

    Watcher.prototype.loadAllStylesheets = function() {};

    Watcher.prototype.emitGlobalsChanged = function() {
      return this.emitter.emit('did-change-globals');
    };

    Watcher.prototype.watchDirectory = function(directoryPath) {
      var entity;
      entity = new Directory(directoryPath);
      this.disposables.add(entity.onDidChange((function(_this) {
        return function() {
          return _this.loadAllStylesheets();
        };
      })(this)));
      return this.entities.push(entity);
    };

    Watcher.prototype.watchGlobalFile = function(filePath) {
      var entity;
      entity = new File(filePath);
      this.disposables.add(entity.onDidChange((function(_this) {
        return function() {
          return _this.emitGlobalsChanged();
        };
      })(this)));
      return this.entities.push(entity);
    };

    Watcher.prototype.watchFile = function(filePath) {
      var entity, reloadFn;
      reloadFn = (function(_this) {
        return function() {
          return _this.loadStylesheet(entity.getPath());
        };
      })(this);
      entity = new File(filePath);
      this.disposables.add(entity.onDidChange(reloadFn));
      this.disposables.add(entity.onDidDelete(reloadFn));
      this.disposables.add(entity.onDidRename(reloadFn));
      return this.entities.push(entity);
    };

    return Watcher;

  })();

}).call(this);
