(function() {
  var PackageWatcher, UIWatcher, path, _;

  _ = require('underscore-plus');

  path = require('path');

  UIWatcher = require('../lib/ui-watcher');

  PackageWatcher = require('../lib/package-watcher');

  describe("UIWatcher", function() {
    var themeManager, uiWatcher;
    themeManager = null;
    uiWatcher = null;
    afterEach(function() {
      return uiWatcher != null ? uiWatcher.destroy() : void 0;
    });
    describe("when a base theme's file changes", function() {
      beforeEach(function() {
        return uiWatcher = new UIWatcher();
      });
      return it("reloads all the base styles", function() {
        spyOn(atom.themes, 'reloadBaseStylesheets');
        expect(uiWatcher.baseTheme.entities[1].getPath()).toContain("" + path.sep + "static" + path.sep);
        uiWatcher.baseTheme.entities[0].emitter.emit('did-change');
        return expect(atom.themes.reloadBaseStylesheets).toHaveBeenCalled();
      });
    });
    it("watches all the style sheets in the theme's styles folder", function() {
      var packagePath;
      packagePath = path.join(__dirname, 'fixtures', 'package-with-styles-folder');
      waitsForPromise(function() {
        return atom.packages.activatePackage(packagePath);
      });
      return runs(function() {
        uiWatcher = new UIWatcher();
        expect(_.last(uiWatcher.watchers).entities.length).toBe(4);
        expect(_.last(uiWatcher.watchers).entities[0].getPath()).toBe(path.join(packagePath, 'styles'));
        expect(_.last(uiWatcher.watchers).entities[1].getPath()).toBe(path.join(packagePath, 'styles', '3.css'));
        expect(_.last(uiWatcher.watchers).entities[2].getPath()).toBe(path.join(packagePath, 'styles', 'sub', '1.css'));
        return expect(_.last(uiWatcher.watchers).entities[3].getPath()).toBe(path.join(packagePath, 'styles', 'sub', '2.less'));
      });
    });
    describe("when a package stylesheet file changes", function() {
      beforeEach(function() {
        waitsForPromise(function() {
          return atom.packages.activatePackage(path.join(__dirname, 'fixtures', 'package-with-styles-manifest'));
        });
        return runs(function() {
          return uiWatcher = new UIWatcher();
        });
      });
      return it("reloads all package styles", function() {
        var pack;
        pack = atom.packages.getActivePackages()[0];
        spyOn(pack, 'reloadStylesheets');
        _.last(uiWatcher.watchers).entities[1].emitter.emit('did-change');
        return expect(pack.reloadStylesheets).toHaveBeenCalled();
      });
    });
    describe("when a package does not have a stylesheet", function() {
      beforeEach(function() {
        waitsForPromise(function() {
          return atom.packages.activatePackage("package-with-index");
        });
        return runs(function() {
          return uiWatcher = new UIWatcher();
        });
      });
      return it("does not create a PackageWatcher", function() {
        return expect(uiWatcher.watchedPackages['package-with-index']).toBeUndefined();
      });
    });
    describe("when a package global file changes", function() {
      beforeEach(function() {
        atom.packages.packageDirPaths.push(path.join(__dirname, 'fixtures'));
        atom.config.set('core.themes', ["theme-with-ui-variables", "theme-with-multiple-imported-files"]);
        waitsForPromise(function() {
          return atom.themes.activateThemes();
        });
        return runs(function() {
          return uiWatcher = new UIWatcher();
        });
      });
      afterEach(function() {
        return atom.themes.deactivateThemes();
      });
      return it("reloads every package when the variables file changes", function() {
        var entity, pack, varEntity, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _results;
        _ref = atom.themes.getActiveThemes();
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          pack = _ref[_i];
          spyOn(pack, 'reloadStylesheets');
        }
        _ref1 = uiWatcher.watchedThemes['theme-with-multiple-imported-files'].entities;
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          entity = _ref1[_j];
          if (entity.getPath().indexOf('variables') > -1) {
            varEntity = entity;
          }
        }
        varEntity.emitter.emit('did-change');
        _ref2 = atom.themes.getActiveThemes();
        _results = [];
        for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
          pack = _ref2[_k];
          _results.push(expect(pack.reloadStylesheets).toHaveBeenCalled());
        }
        return _results;
      });
    });
    describe("minimal theme packages", function() {
      var pack;
      pack = null;
      beforeEach(function() {
        atom.config.set('core.themes', ["theme-with-syntax-variables", "theme-with-index-less"]);
        waitsForPromise(function() {
          return atom.themes.activateThemes();
        });
        return runs(function() {
          uiWatcher = new UIWatcher();
          return pack = atom.themes.getActiveThemes()[0];
        });
      });
      afterEach(function() {
        return atom.themes.deactivateThemes();
      });
      return it("watches themes without a styles directory", function() {
        var watcher;
        spyOn(pack, 'reloadStylesheets');
        spyOn(atom.themes, 'reloadBaseStylesheets');
        watcher = uiWatcher.watchedThemes['theme-with-index-less'];
        expect(watcher.entities.length).toBe(1);
        watcher.entities[0].emitter.emit('did-change');
        expect(pack.reloadStylesheets).toHaveBeenCalled();
        return expect(atom.themes.reloadBaseStylesheets).not.toHaveBeenCalled();
      });
    });
    return describe("theme packages", function() {
      var pack;
      pack = null;
      beforeEach(function() {
        atom.config.set('core.themes', ["theme-with-syntax-variables", "theme-with-multiple-imported-files"]);
        waitsForPromise(function() {
          return atom.themes.activateThemes();
        });
        return runs(function() {
          uiWatcher = new UIWatcher();
          return pack = atom.themes.getActiveThemes()[0];
        });
      });
      afterEach(function() {
        return atom.themes.deactivateThemes();
      });
      it("reloads the theme when anything within the theme changes", function() {
        var watcher;
        spyOn(pack, 'reloadStylesheets');
        spyOn(atom.themes, 'reloadBaseStylesheets');
        watcher = uiWatcher.watchedThemes['theme-with-multiple-imported-files'];
        expect(watcher.entities.length).toBe(6);
        watcher.entities[2].emitter.emit('did-change');
        expect(pack.reloadStylesheets).toHaveBeenCalled();
        expect(atom.themes.reloadBaseStylesheets).not.toHaveBeenCalled();
        _.last(watcher.entities).emitter.emit('did-change');
        return expect(atom.themes.reloadBaseStylesheets).toHaveBeenCalled();
      });
      it("unwatches when a theme is deactivated", function() {
        atom.config.set('core.themes', []);
        return waitsFor(function() {
          return !uiWatcher.watchedThemes["theme-with-multiple-imported-files"];
        });
      });
      return it("watches a new theme when it is deactivated", function() {
        atom.config.set('core.themes', ["theme-with-syntax-variables", "theme-with-package-file"]);
        waitsFor(function() {
          return uiWatcher.watchedThemes["theme-with-package-file"];
        });
        return runs(function() {
          var watcher;
          pack = atom.themes.getActiveThemes()[0];
          spyOn(pack, 'reloadStylesheets');
          expect(pack.name).toBe("theme-with-package-file");
          watcher = uiWatcher.watchedThemes["theme-with-package-file"];
          watcher.entities[2].emitter.emit('did-change');
          return expect(pack.reloadStylesheets).toHaveBeenCalled();
        });
      });
    });
  });

}).call(this);
