(function() {
  var EncodingListView, SelectListView, fs,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  fs = require('fs');

  SelectListView = require('atom-space-pen-views').SelectListView;

  module.exports = EncodingListView = (function(_super) {
    __extends(EncodingListView, _super);

    function EncodingListView() {
      return EncodingListView.__super__.constructor.apply(this, arguments);
    }

    EncodingListView.prototype.initialize = function(encodings) {
      this.encodings = encodings;
      EncodingListView.__super__.initialize.apply(this, arguments);
      this.panel = atom.workspace.addModalPanel({
        item: this,
        visible: false
      });
      this.addClass('encoding-selector');
      return this.list.addClass('mark-active');
    };

    EncodingListView.prototype.getFilterKey = function() {
      return 'name';
    };

    EncodingListView.prototype.viewForItem = function(encoding) {
      var element;
      element = document.createElement('li');
      if (encoding.id === this.currentEncoding) {
        element.classList.add('active');
      }
      element.textContent = encoding.name;
      element.dataset.encoding = encoding.id;
      return element;
    };

    EncodingListView.prototype.detectEncoding = function() {
      var filePath, iconv, jschardet;
      filePath = this.editor.getPath();
      if (!fs.existsSync(filePath)) {
        return;
      }
      jschardet = require('jschardet');
      iconv = require('iconv-lite');
      return fs.readFile(filePath, (function(_this) {
        return function(error, buffer) {
          var encoding, _ref;
          if (error != null) {
            return;
          }
          encoding = ((_ref = jschardet.detect(buffer)) != null ? _ref : {}).encoding;
          if (encoding === 'ascii') {
            encoding = 'utf8';
          }
          if (!iconv.encodingExists(encoding)) {
            return;
          }
          encoding = encoding.toLowerCase().replace(/[^0-9a-z]|:\d{4}$/g, '');
          return _this.editor.setEncoding(encoding);
        };
      })(this));
    };

    EncodingListView.prototype.toggle = function() {
      if (this.panel.isVisible()) {
        return this.cancel();
      } else if (this.editor = atom.workspace.getActiveTextEditor()) {
        return this.attach();
      }
    };

    EncodingListView.prototype.destroy = function() {
      return this.panel.destroy();
    };

    EncodingListView.prototype.cancelled = function() {
      return this.panel.hide();
    };

    EncodingListView.prototype.confirmed = function(encoding) {
      this.cancel();
      if (encoding.id === 'detect') {
        return this.detectEncoding();
      } else {
        return this.editor.setEncoding(encoding.id);
      }
    };

    EncodingListView.prototype.addEncodings = function() {
      var encodingItems, id, names, _ref;
      this.currentEncoding = this.editor.getEncoding();
      encodingItems = [];
      if (fs.existsSync(this.editor.getPath())) {
        encodingItems.push({
          id: 'detect',
          name: 'Auto Detect'
        });
      }
      _ref = this.encodings;
      for (id in _ref) {
        names = _ref[id];
        encodingItems.push({
          id: id,
          name: names.list
        });
      }
      return this.setItems(encodingItems);
    };

    EncodingListView.prototype.attach = function() {
      this.storeFocusedElement();
      this.addEncodings();
      this.panel.show();
      return this.focusFilterEditor();
    };

    return EncodingListView;

  })(SelectListView);

}).call(this);
