(function() {
  var EncodingStatusView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  EncodingStatusView = (function(_super) {
    __extends(EncodingStatusView, _super);

    function EncodingStatusView() {
      return EncodingStatusView.__super__.constructor.apply(this, arguments);
    }

    EncodingStatusView.prototype.initialize = function(statusBar, encodings) {
      this.statusBar = statusBar;
      this.encodings = encodings;
      this.classList.add('encoding-status', 'inline-block');
      this.encodingLink = document.createElement('a');
      this.encodingLink.classList.add('inline-block');
      this.encodingLink.href = '#';
      this.appendChild(this.encodingLink);
      return this.handleEvents();
    };

    EncodingStatusView.prototype.attach = function() {
      return this.tile = this.statusBar.addRightTile({
        priority: 11,
        item: this
      });
    };

    EncodingStatusView.prototype.handleEvents = function() {
      var clickHandler;
      this.activeItemSubscription = atom.workspace.onDidChangeActivePaneItem((function(_this) {
        return function() {
          return _this.subscribeToActiveTextEditor();
        };
      })(this));
      clickHandler = (function(_this) {
        return function() {
          atom.commands.dispatch(atom.views.getView(_this.getActiveTextEditor()), 'encoding-selector:show');
          return false;
        };
      })(this);
      this.addEventListener('click', clickHandler);
      this.clickSubscription = {
        dispose: (function(_this) {
          return function() {
            return _this.removeEventListener('click', clickHandler);
          };
        })(this)
      };
      return this.subscribeToActiveTextEditor();
    };

    EncodingStatusView.prototype.destroy = function() {
      var _ref, _ref1, _ref2, _ref3, _ref4;
      if ((_ref = this.activeItemSubscription) != null) {
        _ref.dispose();
      }
      if ((_ref1 = this.encodingSubscription) != null) {
        _ref1.dispose();
      }
      if ((_ref2 = this.clickSubscription) != null) {
        _ref2.dispose();
      }
      if ((_ref3 = this.configSubscription) != null) {
        _ref3.off();
      }
      return (_ref4 = this.tile) != null ? _ref4.destroy() : void 0;
    };

    EncodingStatusView.prototype.getActiveTextEditor = function() {
      return atom.workspace.getActiveTextEditor();
    };

    EncodingStatusView.prototype.subscribeToActiveTextEditor = function() {
      var _ref, _ref1;
      if ((_ref = this.encodingSubscription) != null) {
        _ref.dispose();
      }
      this.encodingSubscription = (_ref1 = this.getActiveTextEditor()) != null ? _ref1.onDidChangeEncoding((function(_this) {
        return function() {
          return _this.updateEncodingText();
        };
      })(this)) : void 0;
      return this.updateEncodingText();
    };

    EncodingStatusView.prototype.updateEncodingText = function() {
      var encoding, _ref, _ref1, _ref2;
      encoding = (_ref = this.getActiveTextEditor()) != null ? _ref.getEncoding() : void 0;
      if (encoding != null) {
        encoding = encoding.toLowerCase().replace(/[^0-9a-z]|:\d{4}$/g, '');
        this.encodingLink.textContent = (_ref1 = (_ref2 = this.encodings[encoding]) != null ? _ref2.status : void 0) != null ? _ref1 : encoding;
        this.encodingLink.dataset.encoding = encoding;
        return this.style.display = '';
      } else {
        return this.style.display = 'none';
      }
    };

    return EncodingStatusView;

  })(HTMLDivElement);

  module.exports = document.registerElement('encoding-selector-status', {
    prototype: EncodingStatusView.prototype
  });

}).call(this);
