(function() {
  var $, path;

  path = require('path');

  $ = require('atom-space-pen-views').$;

  describe("EncodingSelector", function() {
    var editor, editorView, _ref;
    _ref = [], editor = _ref[0], editorView = _ref[1];
    beforeEach(function() {
      jasmine.attachToDOM(atom.views.getView(atom.workspace));
      waitsForPromise(function() {
        return atom.packages.activatePackage('status-bar');
      });
      waitsForPromise(function() {
        return atom.packages.activatePackage('encoding-selector');
      });
      waitsForPromise(function() {
        return atom.workspace.open('sample.js');
      });
      return runs(function() {
        editor = atom.workspace.getActiveTextEditor();
        return editorView = atom.views.getView(editor);
      });
    });
    describe("when encoding-selector:show is triggered", function() {
      return it("displays a list of all the available encodings", function() {
        var encodingView;
        atom.commands.dispatch(editorView, 'encoding-selector:show');
        encodingView = $(atom.views.getView(atom.workspace)).find('.encoding-selector').view();
        expect(encodingView).toExist();
        return expect(encodingView.list.children('li').length).toBeGreaterThan(1);
      });
    });
    describe("when an encoding is selected", function() {
      return it("sets the new encoding on the editor", function() {
        var encodingView;
        atom.commands.dispatch(editorView, 'encoding-selector:show');
        encodingView = $(atom.views.getView(atom.workspace)).find('.encoding-selector').view();
        encodingView.confirmed({
          id: 'utf16le'
        });
        return expect(editor.getEncoding()).toBe('utf16le');
      });
    });
    describe("when Auto Detect is selected", function() {
      return it("detects the character set and applies that encoding", function() {
        var encodingChangeHandler;
        encodingChangeHandler = jasmine.createSpy('encodingChangeHandler');
        editor.onDidChangeEncoding(encodingChangeHandler);
        editor.setEncoding('utf16le');
        waitsFor(function() {
          return encodingChangeHandler.callCount === 1;
        });
        runs(function() {
          var encodingView;
          atom.commands.dispatch(editorView, 'encoding-selector:show');
          encodingView = $(atom.views.getView(atom.workspace)).find('.encoding-selector').view();
          encodingView.confirmed({
            id: 'detect'
          });
          return encodingChangeHandler.reset();
        });
        waitsFor(function() {
          return encodingChangeHandler.callCount === 1;
        });
        return runs(function() {
          return expect(editor.getEncoding()).toBe('utf8');
        });
      });
    });
    return describe("encoding label", function() {
      var encodingStatus;
      encodingStatus = [][0];
      beforeEach(function() {
        return runs(function() {
          encodingStatus = document.querySelector('encoding-selector-status');
          return expect(encodingStatus).toExist();
        });
      });
      it("displays the name of the current encoding", function() {
        return expect(encodingStatus.encodingLink.textContent).toBe('UTF-8');
      });
      it("hides the label when the current encoding is null", function() {
        spyOn(editor, 'getEncoding').andReturn(null);
        editor.setEncoding('utf16le');
        return expect(encodingStatus).toBeHidden();
      });
      describe("when the editor's encoding changes", function() {
        return it("displays the new encoding of the editor", function() {
          expect(encodingStatus.encodingLink.textContent).toBe('UTF-8');
          editor.setEncoding('utf16le');
          return expect(encodingStatus.encodingLink.textContent).toBe('UTF-16 LE');
        });
      });
      describe("when clicked", function() {
        return it("toggles the encoding-selector:show event", function() {
          var eventHandler;
          eventHandler = jasmine.createSpy('eventHandler');
          atom.commands.add('atom-text-editor', 'encoding-selector:show', eventHandler);
          encodingStatus.click();
          return expect(eventHandler).toHaveBeenCalled();
        });
      });
      return describe("when the package is deactivated", function() {
        return it("removes the view", function() {
          atom.packages.deactivatePackage('encoding-selector');
          return expect(encodingStatus.parentElement).toBeNull();
        });
      });
    });
  });

}).call(this);
