(function() {
  var Reporter;

  Reporter = null;

  module.exports = {
    activate: function() {
      if (!atom.config.get('exception-reporting.userId')) {
        atom.config.set('exception-reporting.userId', require('guid').raw());
      }
      return this.uncaughtErrorSubscription = atom.onDidThrowError(function(_arg) {
        var column, line, message, originalError, url;
        message = _arg.message, url = _arg.url, line = _arg.line, column = _arg.column, originalError = _arg.originalError;
        if (Reporter == null) {
          Reporter = require('./reporter');
        }
        return Reporter.send(message, url, line, column, originalError);
      });
    },
    deactivate: function() {
      var _ref;
      if ((_ref = this.uncaughtErrorSubscription) != null) {
        _ref.dispose();
      }
      return this.uncaughtErrorSubscription = null;
    }
  };

}).call(this);
