(function() {
  var Reporter, coffeestack, os, path, request, _;

  os = require('os');

  path = require('path');

  _ = require('underscore-plus');

  coffeestack = require('coffeestack');

  request = require('request');

  module.exports = Reporter = (function() {
    function Reporter() {}

    Reporter.send = function(message, url, line, column, error) {
      if (!this.shouldSendErrorFromUrl(url)) {
        return;
      }
      return this.request({
        method: 'POST',
        url: 'https://notify.bugsnag.com',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify(this.buildParams(message, url, line, column, error))
      });
    };

    Reporter.request = function(options) {
      return request(options, function() {});
    };

    Reporter.buildParams = function(message, url, line, column, error) {
      var atLinePattern, context, errorClass, match, params, releaseStage, resourcePath, source, stacktrace, _i, _len, _ref, _ref1, _ref2;
      message = message.substring(0, 5 * 1024);
      if (!(errorClass = error != null ? error.name : void 0)) {
        if (errorClass = message.split(':', 1)[0]) {
          errorClass = errorClass.replace('Uncaught ', '');
        } else {
          errorClass = "UncaughtError";
        }
      }
      releaseStage = atom.isReleasedVersion() ? 'production' : 'development';
      _ref1 = (_ref = coffeestack.convertLine(url, line, column)) != null ? _ref : {
        line: line,
        column: column,
        source: url
      }, line = _ref1.line, column = _ref1.column, source = _ref1.source;
      context = path.basename(source);
      stacktrace = [];
      if ((error != null ? error.stack : void 0) != null) {
        atLinePattern = /^(\s+at (.*) )\((.*):(\d+):(\d+)\)/;
        _ref2 = coffeestack.convertStackTrace(error.stack).split('\n');
        for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
          line = _ref2[_i];
          if (match = atLinePattern.exec(line)) {
            resourcePath = _.escapeRegExp(atom.getLoadSettings().resourcePath);
            stacktrace.push({
              file: match[3].replace(RegExp("^" + resourcePath + "[/\\\\]", "i"), ''),
              method: match[2].replace(/^(HTMLDocument|HTML[^\.]*Element|Object)\./, ''),
              columnNumber: parseInt(match[5]),
              lineNumber: parseInt(match[4]),
              inProject: !/node_modules/.test(match[3])
            });
          }
        }
      } else {
        stacktrace.push({
          file: source,
          method: ' ',
          columnNumber: column,
          lineNumber: line,
          inProject: true
        });
      }
      return params = {
        apiKey: '7ddca14cb60cbd1cd12d1b252473b076',
        notifier: {
          name: 'Atom',
          version: atom.getVersion(),
          url: 'https://www.atom.io'
        },
        events: [
          {
            userId: atom.config.get('exception-reporting.userId'),
            appVersion: atom.getVersion(),
            osVersion: "" + (os.platform()) + "-" + (os.arch()) + "-" + (os.release()),
            releaseStage: releaseStage,
            context: context,
            exceptions: [
              {
                errorClass: errorClass,
                message: message,
                stacktrace: stacktrace
              }
            ],
            metaData: error != null ? error.metadata : void 0
          }
        ]
      };
    };

    Reporter.shouldSendErrorFromUrl = function(url) {
      var resourcePath;
      resourcePath = atom.getLoadSettings().resourcePath;
      return !atom.inDevMode() && url.indexOf(resourcePath) === 0;
    };

    return Reporter;

  })();

}).call(this);
