(function() {
  var Reporter, path;

  path = require('path');

  Reporter = require('../lib/reporter');

  describe("Reporter", function() {
    beforeEach(function() {
      spyOn(Reporter, 'request');
      spyOn(atom, 'inDevMode').andReturn(false);
      return waitsForPromise(function() {
        return atom.packages.activatePackage('exception-reporting');
      });
    });
    describe("when the exception is from atom core", function() {
      var filePath;
      filePath = null;
      beforeEach(function() {
        return filePath = path.join(atom.getLoadSettings().resourcePath, 'file.coffee');
      });
      it("sends a request with the proper options", function() {
        var body, error, requestArgs;
        error = {
          stack: "Error: whoops\n  at HTMLDivElement.<anonymous> (" + atom.config.resourcePath + "/fuzzy-finder.coffee:10:15)\n  at HTMLDivElement.jQuery.event.dispatch (" + atom.config.resourcePath + "/node_modules/space-pen/vendor/jquery.js:4676:9)"
        };
        window.onerror('message', filePath, 1, 2, error);
        expect(Reporter.request).toHaveBeenCalled();
        requestArgs = Reporter.request.calls[0].args[0];
        body = JSON.parse(requestArgs.body);
        expect(requestArgs.method).toBe('POST');
        expect(requestArgs.url).toBe('https://notify.bugsnag.com');
        expect(requestArgs.headers['Content-Type']).toBe('application/json');
        expect(body.apiKey).toBeDefined();
        expect(body.notifier).toBeDefined();
        expect(body.events).toBeDefined();
        expect(body.events[0].context).toEqual('file.coffee');
        expect(body.events[0].exceptions[0].message).toEqual('message');
        return expect(body.events[0].exceptions[0].stacktrace).toEqual([
          {
            file: 'fuzzy-finder.coffee',
            method: '<anonymous>',
            columnNumber: 15,
            lineNumber: 10,
            inProject: true
          }, {
            file: 'node_modules/space-pen/vendor/jquery.js',
            method: 'jQuery.event.dispatch',
            columnNumber: 9,
            lineNumber: 4676,
            inProject: false
          }
        ]);
      });
      return it("truncates large backtraces", function() {
        var body, largeString;
        largeString = Array(1024 * 6).join("a");
        window.onerror(largeString, filePath, 1);
        body = JSON.parse(Reporter.request.calls[0].args[0].body);
        window.onerror(largeString, 'file.coffee', 1);
        return expect(body.events[0].exceptions[0].message.length).toBeLessThan(largeString.length);
      });
    });
    return describe("when the exception is not from atom core", function() {
      return it("doesn't send a request with the proper options", function() {
        window.onerror('message', 'file.coffee', 1);
        return expect(Reporter.request).not.toHaveBeenCalled();
      });
    });
  });

}).call(this);
