(function() {
  var $, SurveyURL;

  $ = require('jquery');

  SurveyURL = 'https://atom.io/survey';

  module.exports = {
    PollInterval: 10000,
    getClientID: function() {
      return localStorage.getItem('metrics.userId');
    },
    getSurveyURL: function(source) {
      return "" + SurveyURL + "/" + source + "/" + (this.getClientID());
    },
    fetchSurveyMetadata: function(source) {
      return new Promise((function(_this) {
        return function(resolve) {
          var url;
          url = "https://atom.io/api/feedback/" + source;
          return $.ajax(url, {
            accept: 'application/json',
            contentType: "application/json",
            success: function(data) {
              return resolve(data);
            },
            error: function() {
              return resolve({
                display_seed: 'none',
                display_percent: 0
              });
            }
          });
        };
      })(this));
    },
    fetchDidCompleteFeedback: function(source) {
      return new Promise((function(_this) {
        return function(resolve) {
          var url;
          url = "https://atom.io/api/feedback/" + source + "/" + (_this.getClientID());
          return $.ajax(url, {
            accept: 'application/json',
            contentType: "application/json",
            success: function(data) {
              return resolve(data.completed);
            }
          });
        };
      })(this));
    },
    detectDidCompleteFeedback: function(source) {
      var detectCompleted;
      detectCompleted = (function(_this) {
        return function(callback) {
          _this.cancelDidCompleteFeedbackDetection();
          return _this.detectionTimeout = setTimeout(function() {
            return _this.fetchDidCompleteFeedback(source).then(function(didCompleteFeedback) {
              if (didCompleteFeedback) {
                return callback(true);
              } else {
                return detectCompleted(callback);
              }
            });
          }, _this.PollInterval);
        };
      })(this);
      return new Promise((function(_this) {
        return function(resolve) {
          return detectCompleted(function(completed) {
            return resolve(completed);
          });
        };
      })(this));
    },
    cancelDidCompleteFeedbackDetection: function() {
      clearTimeout(this.detectionTimeout);
      return this.detectionTimeout = null;
    }
  };

}).call(this);
