(function() {
  var Emitter, FeedbackModalElement, Template,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Emitter = require('atom').Emitter;

  Template = "<h1>Help Improve Atom</h1>\n<p>\n  Our engineers and designers are interested in how you use Atom and where we\n  can improve the experience.\n</p>\n<p>\n  We'll share what we learn in a blog post.\n</p>\n<div class=\"btn-toolbar\">\n  <a href=\"{{SurveyURL}}\" class=\"btn btn-primary\">1-minute survey</a>\n  <a href=\"#\" class=\"btn btn-cancel\">Not right now</a>\n</div>";

  module.exports = FeedbackModalElement = (function(_super) {
    __extends(FeedbackModalElement, _super);

    function FeedbackModalElement() {
      return FeedbackModalElement.__super__.constructor.apply(this, arguments);
    }

    FeedbackModalElement.prototype.initialize = function(_arg) {
      var FeedbackAPI, Reporter, feedbackSource;
      feedbackSource = _arg.feedbackSource;
      this.emitter = new Emitter;
      Reporter = require('./reporter');
      FeedbackAPI = require('./feedback-api');
      this.innerHTML = Template.replace('{{SurveyURL}}', FeedbackAPI.getSurveyURL(feedbackSource));
      this.querySelector('.btn-primary').addEventListener('click', (function(_this) {
        return function() {
          Reporter.sendEvent('did-click-modal-cta');
          _this.emitter.emit('did-start-survey');
          return _this.hide();
        };
      })(this));
      return this.querySelector('.btn-cancel').addEventListener('click', (function(_this) {
        return function() {
          Reporter.sendEvent('did-click-modal-cancel');
          return _this.hide();
        };
      })(this));
    };

    FeedbackModalElement.prototype.onDidStartSurvey = function(callback) {
      return this.emitter.on('did-start-survey', callback);
    };

    FeedbackModalElement.prototype.show = function() {
      if (this.modalPanel == null) {
        this.modalPanel = atom.workspace.addModalPanel({
          item: this
        });
      }
      return this.modalPanel.show();
    };

    FeedbackModalElement.prototype.hide = function() {
      return this.modalPanel.hide();
    };

    FeedbackModalElement.prototype.destroy = function() {
      var _ref;
      if ((_ref = this.modalPanel) != null) {
        _ref.destroy();
      }
      this.modalPanel = null;
      return this.emitter.dispose();
    };

    return FeedbackModalElement;

  })(HTMLElement);

  module.exports = document.registerElement('feedback-modal', {
    prototype: FeedbackModalElement.prototype
  });

}).call(this);
