(function() {
  var FeedbackStatusElement, Template,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Template = "<a href=\"#\" class=\"inline-block\">1-minute survey</a>";

  module.exports = FeedbackStatusElement = (function(_super) {
    __extends(FeedbackStatusElement, _super);

    function FeedbackStatusElement() {
      return FeedbackStatusElement.__super__.constructor.apply(this, arguments);
    }

    FeedbackStatusElement.prototype.initialize = function(_arg) {
      this.feedbackSource = _arg.feedbackSource;
    };

    FeedbackStatusElement.prototype.attachedCallback = function() {
      this.innerHTML = Template;
      atom.tooltips.add(this, {
        title: "Help us improve Atom by giving feedback"
      });
      if (!localStorage.getItem("hasClickedSurveyLink-" + this.feedbackSource)) {
        this.classList.add('promote');
      }
      return this.querySelector('a').addEventListener('click', (function(_this) {
        return function(e) {
          var Reporter;
          localStorage.setItem("hasClickedSurveyLink-" + _this.feedbackSource, true);
          _this.classList.remove('promote');
          Reporter = require('./reporter');
          Reporter.sendEvent('did-click-status-bar-link');
          e.preventDefault();
          return atom.commands.dispatch(_this, 'feedback:show');
        };
      })(this));
    };

    return FeedbackStatusElement;

  })(HTMLElement);

  module.exports = document.registerElement('feedback-status', {
    prototype: FeedbackStatusElement.prototype
  });

}).call(this);
