(function() {
  var CompositeDisposable, FeedbackAPI, Reporter;

  CompositeDisposable = require('atom').CompositeDisposable;

  FeedbackAPI = null;

  Reporter = null;

  module.exports = {
    config: {
      alwaysShowInDevMode: {
        type: 'boolean',
        "default": false
      }
    },
    feedbackSource: 'survey-2015-1',
    activate: function() {
      this.statusBarPromise = new Promise((function(_this) {
        return function(resolve) {
          return _this.resolveStatusBarPromise = resolve;
        };
      })(this));
      return process.nextTick((function(_this) {
        return function() {
          FeedbackAPI = require('./feedback-api');
          return _this.checkShouldRequestFeedback().then(function(shouldRequestFeedback) {
            if (Reporter == null) {
              Reporter = require('./reporter');
            }
            if (shouldRequestFeedback) {
              _this.addStatusBarItem();
              _this.subscriptions = new CompositeDisposable;
              _this.subscriptions.add(atom.commands.add('atom-workspace', 'feedback:show', function() {
                return _this.showModal();
              }));
              return Reporter.sendEvent('did-show-status-bar-link');
            }
          });
        };
      })(this));
    },
    consumeStatusBar: function(statusBar) {
      return this.resolveStatusBarPromise(statusBar);
    },
    consumeReporter: function(realReporter) {
      if (Reporter == null) {
        Reporter = require('./reporter');
      }
      return Reporter.setReporter(realReporter);
    },
    getStatusBar: function() {
      return this.statusBarPromise;
    },
    addStatusBarItem: function() {
      var FeedbackStatusElement, workspaceElement;
      if (this.statusBarTile != null) {
        return;
      }
      FeedbackStatusElement = require('./feedback-status-element');
      workspaceElement = atom.views.getView(atom.workspace);
      return this.getStatusBar().then((function(_this) {
        return function(statusBar) {
          var item;
          item = new FeedbackStatusElement();
          item.initialize({
            feedbackSource: _this.feedbackSource
          });
          return _this.statusBarTile = statusBar.addRightTile({
            item: item,
            priority: -1
          });
        };
      })(this));
    },
    showModal: function() {
      var FeedbackModalElement;
      if (this.modal == null) {
        FeedbackModalElement = require('./feedback-modal-element');
        this.modal = new FeedbackModalElement();
        this.modal.initialize({
          feedbackSource: this.feedbackSource
        });
        this.modal.onDidStartSurvey((function(_this) {
          return function() {
            return _this.detectCompletedSurvey();
          };
        })(this));
      }
      return this.modal.show();
    },
    checkShouldRequestFeedback: function() {
      var client;
      client = FeedbackAPI.getClientID();
      return FeedbackAPI.fetchSurveyMetadata(this.feedbackSource).then((function(_this) {
        return function(metadata) {
          return new Promise(function(resolve) {
            var checksum, crc32, shouldRequest, _ref, _ref1;
            shouldRequest = atom.inSpecMode() || (atom.inDevMode() && atom.config.get('feedback.alwaysShowInDevMode')) ? true : client ? ((_ref = require('crc'), crc32 = _ref.crc32, _ref), checksum = crc32(client + _this.feedbackSource + metadata.display_seed), checksum % 100 < ((_ref1 = metadata.display_percent) != null ? _ref1 : 0)) : false;
            if (shouldRequest) {
              return FeedbackAPI.fetchDidCompleteFeedback(_this.feedbackSource).then(function(didCompleteSurvey) {
                if (Reporter == null) {
                  Reporter = require('./reporter');
                }
                if (didCompleteSurvey) {
                  Reporter.sendEvent('already-finished-survey');
                }
                return resolve(!didCompleteSurvey);
              });
            } else {
              return resolve(false);
            }
          });
        };
      })(this));
    },
    detectCompletedSurvey: function() {
      return FeedbackAPI.detectDidCompleteFeedback(this.feedbackSource).then((function(_this) {
        return function() {
          if (Reporter == null) {
            Reporter = require('./reporter');
          }
          Reporter.sendEvent('did-finish-survey');
          return _this.statusBarTile.destroy();
        };
      })(this));
    },
    deactivate: function() {
      var _ref, _ref1, _ref2;
      if ((_ref = this.subscriptions) != null) {
        _ref.dispose();
      }
      if ((_ref1 = this.statusBarTile) != null) {
        _ref1.destroy();
      }
      this.statusBarTile = null;
      if ((_ref2 = this.modal) != null) {
        _ref2.destroy();
      }
      return this.modal = null;
    }
  };

}).call(this);
