(function() {
  var $, CompositeDisposable, FindModel, FindView, History, ProjectFindView, ResultsModel, ResultsPaneView, SelectNext;

  $ = require('atom-space-pen-views').$;

  CompositeDisposable = require('atom').CompositeDisposable;

  SelectNext = require('./select-next');

  History = require('./history').History;

  FindModel = require('./find-model');

  FindView = require('./find-view');

  ProjectFindView = require('./project-find-view');

  ResultsModel = require('./project/results-model');

  ResultsPaneView = require('./project/results-pane');

  module.exports = {
    config: {
      focusEditorAfterSearch: {
        type: 'boolean',
        "default": false
      },
      openProjectFindResultsInRightPane: {
        type: 'boolean',
        "default": false
      }
    },
    activate: function(_arg) {
      var findHistory, handleEditorCancel, pathsHistory, replaceHistory, selectNextObjectForEditorElement, _ref;
      _ref = _arg != null ? _arg : {}, this.viewState = _ref.viewState, this.projectViewState = _ref.projectViewState, this.resultsModelState = _ref.resultsModelState, this.modelState = _ref.modelState, findHistory = _ref.findHistory, replaceHistory = _ref.replaceHistory, pathsHistory = _ref.pathsHistory;
      atom.workspace.addOpener((function(_this) {
        return function(filePath) {
          if (filePath === ResultsPaneView.URI) {
            return new ResultsPaneView();
          }
        };
      })(this));
      this.subscriptions = new CompositeDisposable;
      this.findModel = new FindModel(this.modelState);
      this.resultsModel = new ResultsModel(this.resultsModelState);
      this.findHistory = new History(findHistory);
      this.replaceHistory = new History(replaceHistory);
      this.pathsHistory = new History(pathsHistory);
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show', (function(_this) {
        return function() {
          _this.createViews();
          _this.findPanel.hide();
          _this.projectFindPanel.show();
          return _this.projectFindView.focusFindElement();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:toggle', (function(_this) {
        return function() {
          _this.createViews();
          _this.findPanel.hide();
          if (_this.projectFindPanel.isVisible()) {
            return _this.projectFindPanel.hide();
          } else {
            return _this.projectFindPanel.show();
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'project-find:show-in-current-directory', (function(_this) {
        return function(_arg1) {
          var target;
          target = _arg1.target;
          _this.createViews();
          _this.findPanel.hide();
          _this.projectFindPanel.show();
          return _this.projectFindView.findInCurrentlySelectedDirectory(target);
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:use-selection-as-find-pattern', (function(_this) {
        return function() {
          var _ref1, _ref2;
          if (((_ref1 = _this.projectFindPanel) != null ? _ref1.isVisible() : void 0) || ((_ref2 = _this.findPanel) != null ? _ref2.isVisible() : void 0)) {
            return;
          }
          _this.createViews();
          _this.projectFindPanel.hide();
          _this.findPanel.show();
          return _this.findView.focusFindEditor();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:toggle', (function(_this) {
        return function() {
          _this.createViews();
          _this.projectFindPanel.hide();
          if (_this.findPanel.isVisible()) {
            return _this.findPanel.hide();
          } else {
            _this.findPanel.show();
            return _this.findView.focusFindEditor();
          }
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show', (function(_this) {
        return function() {
          _this.createViews();
          _this.projectFindPanel.hide();
          _this.findPanel.show();
          return _this.findView.focusFindEditor();
        };
      })(this)));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'find-and-replace:show-replace', (function(_this) {
        return function() {
          var _ref1;
          _this.createViews();
          if ((_ref1 = _this.projectFindPanel) != null) {
            _ref1.hide();
          }
          _this.findPanel.show();
          return _this.findView.focusReplaceEditor();
        };
      })(this)));
      handleEditorCancel = (function(_this) {
        return function(_arg1) {
          var isMiniEditor, target, _ref1, _ref2;
          target = _arg1.target;
          isMiniEditor = target.tagName === 'ATOM-TEXT-EDITOR' && target.hasAttribute('mini');
          if (!isMiniEditor) {
            if ((_ref1 = _this.findPanel) != null) {
              _ref1.hide();
            }
            return (_ref2 = _this.projectFindPanel) != null ? _ref2.hide() : void 0;
          }
        };
      })(this);
      this.subscriptions.add(atom.commands.add('atom-workspace', {
        'core:cancel': handleEditorCancel,
        'core:close': handleEditorCancel
      }));
      selectNextObjectForEditorElement = (function(_this) {
        return function(editorElement) {
          var editor, selectNext;
          if (_this.selectNextObjects == null) {
            _this.selectNextObjects = new WeakMap();
          }
          editor = editorElement.getModel();
          selectNext = _this.selectNextObjects.get(editor);
          if (selectNext == null) {
            selectNext = new SelectNext(editor);
            _this.selectNextObjects.set(editor, selectNext);
          }
          return selectNext;
        };
      })(this);
      return atom.commands.add('.editor:not(.mini)', {
        'find-and-replace:select-next': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectNext();
        },
        'find-and-replace:select-all': function(event) {
          return selectNextObjectForEditorElement(this).findAndSelectAll();
        },
        'find-and-replace:select-undo': function(event) {
          return selectNextObjectForEditorElement(this).undoLastSelection();
        },
        'find-and-replace:select-skip': function(event) {
          return selectNextObjectForEditorElement(this).skipCurrentSelection();
        }
      });
    },
    createViews: function() {
      var history;
      if (this.findView != null) {
        return;
      }
      history = {
        findHistory: this.findHistory,
        replaceHistory: this.replaceHistory,
        pathsHistory: this.pathsHistory
      };
      this.findView = new FindView(this.findModel, history);
      this.projectFindView = new ProjectFindView(this.findModel, this.resultsModel, history);
      this.findPanel = atom.workspace.addBottomPanel({
        item: this.findView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.projectFindPanel = atom.workspace.addBottomPanel({
        item: this.projectFindView,
        visible: false,
        className: 'tool-panel panel-bottom'
      });
      this.findView.setPanel(this.findPanel);
      this.projectFindView.setPanel(this.projectFindPanel);
      return ResultsPaneView.model = this.resultsModel;
    },
    deactivate: function() {
      var _ref, _ref1, _ref2, _ref3, _ref4;
      if ((_ref = this.findPanel) != null) {
        _ref.destroy();
      }
      this.findPanel = null;
      if ((_ref1 = this.findView) != null) {
        _ref1.destroy();
      }
      this.findView = null;
      this.findModel = null;
      if ((_ref2 = this.projectFindPanel) != null) {
        _ref2.destroy();
      }
      this.projectFindPanel = null;
      if ((_ref3 = this.projectFindView) != null) {
        _ref3.destroy();
      }
      this.projectFindView = null;
      ResultsPaneView.model = null;
      this.resultsModel = null;
      if ((_ref4 = this.subscriptions) != null) {
        _ref4.dispose();
      }
      return this.subscriptions = null;
    },
    serialize: function() {
      var _ref, _ref1, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7;
      return {
        viewState: (_ref = (_ref1 = this.findView) != null ? _ref1.serialize() : void 0) != null ? _ref : this.viewState,
        modelState: (_ref2 = (_ref3 = this.findModel) != null ? _ref3.serialize() : void 0) != null ? _ref2 : this.modelState,
        projectViewState: (_ref4 = (_ref5 = this.projectFindView) != null ? _ref5.serialize() : void 0) != null ? _ref4 : this.projectViewState,
        resultsModelState: (_ref6 = (_ref7 = this.resultsModel) != null ? _ref7.serialize() : void 0) != null ? _ref6 : this.resultsModelState,
        findHistory: this.findHistory.serialize(),
        replaceHistory: this.replaceHistory.serialize(),
        pathsHistory: this.replaceHistory.serialize()
      };
    }
  };

}).call(this);
