(function() {
  var Emitter, HISTORY_MAX, History, HistoryCycler, _;

  _ = require('underscore-plus');

  Emitter = require('atom').Emitter;

  HISTORY_MAX = 25;

  History = (function() {
    function History(items) {
      this.items = items != null ? items : [];
      this.emitter = new Emitter;
      this.length = this.items.length;
    }

    History.prototype.onDidAddItem = function(callback) {
      return this.emitter.on('did-add-item', callback);
    };

    History.prototype.serialize = function() {
      return this.items.slice(-HISTORY_MAX);
    };

    History.prototype.getLast = function() {
      return _.last(this.items);
    };

    History.prototype.getAtIndex = function(index) {
      return this.items[index];
    };

    History.prototype.add = function(text) {
      this.items.push(text);
      this.length = this.items.length;
      return this.emitter.emit('did-add-item', text);
    };

    return History;

  })();

  HistoryCycler = (function() {
    function HistoryCycler(miniEditor, history) {
      this.miniEditor = miniEditor;
      this.history = history;
      this.index = this.history.length;
      atom.commands.add(this.miniEditor.element, {
        'core:move-up': (function(_this) {
          return function() {
            return _this.previous();
          };
        })(this),
        'core:move-down': (function(_this) {
          return function() {
            return _this.next();
          };
        })(this)
      });
      this.history.onDidAddItem((function(_this) {
        return function(text) {
          if (text !== _this.miniEditor.getText()) {
            return _this.miniEditor.setText(text);
          }
        };
      })(this));
    }

    HistoryCycler.prototype.previous = function() {
      var _ref;
      if (this.history.length === 0 || (this.atLastItem() && this.miniEditor.getText() !== this.history.getLast())) {
        this.scratch = this.miniEditor.getText();
      } else if (this.index > 0) {
        this.index--;
      }
      return this.miniEditor.setText((_ref = this.history.getAtIndex(this.index)) != null ? _ref : '');
    };

    HistoryCycler.prototype.next = function() {
      var item;
      if (this.index < this.history.length - 1) {
        this.index++;
        item = this.history.getAtIndex(this.index);
      } else if (this.scratch) {
        item = this.scratch;
      } else {
        item = '';
      }
      return this.miniEditor.setText(item);
    };

    HistoryCycler.prototype.atLastItem = function() {
      return this.index === this.history.length - 1;
    };

    HistoryCycler.prototype.store = function() {
      var text;
      text = this.miniEditor.getText();
      if (!text || text === this.history.getLast()) {
        return;
      }
      this.scratch = null;
      this.history.add(text);
      return this.index = this.history.length - 1;
    };

    return HistoryCycler;

  })();

  module.exports = {
    History: History,
    HistoryCycler: HistoryCycler
  };

}).call(this);
