(function() {
  var CompositeDisposable, LeadingWhitespace, MatchView, Range, View, removeLeadingWhitespace, _ref,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  View = require('atom-space-pen-views').View;

  _ref = require('atom'), Range = _ref.Range, CompositeDisposable = _ref.CompositeDisposable;

  LeadingWhitespace = /^\s+/;

  removeLeadingWhitespace = function(string) {
    return string.replace(LeadingWhitespace, '');
  };

  module.exports = MatchView = (function(_super) {
    __extends(MatchView, _super);

    function MatchView() {
      this.render = __bind(this.render, this);
      return MatchView.__super__.constructor.apply(this, arguments);
    }

    MatchView.content = function(model, _arg) {
      var filePath, match, matchEnd, matchStart, prefix, range, suffix;
      filePath = _arg.filePath, match = _arg.match;
      range = Range.fromObject(match.range);
      matchStart = range.start.column - match.lineTextOffset;
      matchEnd = range.end.column - match.lineTextOffset;
      prefix = removeLeadingWhitespace(match.lineText.slice(0, matchStart));
      suffix = match.lineText.slice(matchEnd);
      return this.li({
        "class": 'search-result list-item'
      }, (function(_this) {
        return function() {
          _this.span(range.start.row + 1, {
            "class": 'line-number text-subtle'
          });
          return _this.span({
            "class": 'preview',
            outlet: 'preview'
          }, function() {
            _this.span(prefix);
            _this.span(match.matchText, {
              "class": 'match highlight-info',
              outlet: 'matchText'
            });
            _this.span(match.matchText, {
              "class": 'replacement highlight-success',
              outlet: 'replacementText'
            });
            return _this.span(suffix);
          });
        };
      })(this));
    };

    MatchView.prototype.initialize = function(model, _arg) {
      var fontFamily;
      this.model = model;
      this.filePath = _arg.filePath, this.match = _arg.match;
      this.render();
      if (fontFamily = atom.config.get('editor.fontFamily')) {
        return this.preview.css('font-family', fontFamily);
      }
    };

    MatchView.prototype.attached = function() {
      this.subscriptions = new CompositeDisposable;
      return this.subscriptions.add(this.model.onDidChangeReplacementPattern(this.render));
    };

    MatchView.prototype.detached = function() {
      return this.subscriptions.dispose();
    };

    MatchView.prototype.render = function() {
      var replacementText;
      if (this.model.replacementPattern && this.model.regex && (this.model.replacedPathCount == null)) {
        replacementText = this.match.matchText.replace(this.model.regex, this.model.replacementPattern);
        this.replacementText.text(replacementText);
        this.replacementText.show();
        return this.matchText.removeClass('highlight-info').addClass('highlight-error');
      } else {
        this.replacementText.text('').hide();
        return this.matchText.removeClass('highlight-error').addClass('highlight-info');
      }
    };

    MatchView.prototype.confirm = function() {
      return atom.workspace.open(this.filePath, {
        split: 'left'
      }).then((function(_this) {
        return function(editor) {
          return editor.setSelectedBufferRange(_this.match.range, {
            autoscroll: true
          });
        };
      })(this));
    };

    MatchView.prototype.copy = function() {
      return atom.clipboard.write(this.match.lineText);
    };

    return MatchView;

  })(View);

}).call(this);
