(function() {
  var $, MatchView, ResultView, View, fs, path, _, _ref,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  _ = require('underscore-plus');

  _ref = require('atom-space-pen-views'), $ = _ref.$, View = _ref.View;

  fs = require('fs-plus');

  MatchView = require('./match-view');

  path = require('path');

  module.exports = ResultView = (function(_super) {
    __extends(ResultView, _super);

    function ResultView() {
      return ResultView.__super__.constructor.apply(this, arguments);
    }

    ResultView.content = function(model, filePath, result) {
      var fileBasename, iconClass, relativePath, rootPath, _ref1;
      iconClass = fs.isReadmePath(filePath) ? 'icon-book' : 'icon-file-text';
      fileBasename = path.basename(filePath);
      if (atom.project != null) {
        _ref1 = atom.project.relativizePath(filePath), rootPath = _ref1[0], relativePath = _ref1[1];
        if ((rootPath != null) && atom.project.getDirectories().length > 1) {
          relativePath = path.join(path.basename(rootPath), relativePath);
        }
      } else {
        relativePath = filePath;
      }
      return this.li({
        "class": 'path list-nested-item',
        'data-path': _.escapeAttribute(filePath)
      }, (function(_this) {
        return function() {
          _this.div({
            outlet: 'pathDetails',
            "class": 'path-details list-item'
          }, function() {
            _this.span({
              "class": 'disclosure-arrow'
            });
            _this.span({
              "class": iconClass + ' icon',
              'data-name': fileBasename
            });
            _this.span({
              "class": 'path-name bright'
            }, relativePath);
            return _this.span({
              outlet: 'description',
              "class": 'path-match-number'
            });
          });
          return _this.ul({
            outlet: 'matches',
            "class": 'matches list-tree'
          });
        };
      })(this));
    };

    ResultView.prototype.initialize = function(model, filePath, result) {
      this.model = model;
      this.filePath = filePath;
      this.isExpanded = true;
      return this.renderResult(result);
    };

    ResultView.prototype.renderResult = function(result) {
      var match, matches, selectedIndex, _i, _len;
      matches = result != null ? result.matches : void 0;
      selectedIndex = this.matches.find('.selected').index();
      this.matches.empty();
      if (result) {
        this.description.show().text("(" + (matches != null ? matches.length : void 0) + ")");
      } else {
        this.description.hide();
      }
      if (!matches || matches.length === 0) {
        this.hide();
      } else {
        this.show();
        for (_i = 0, _len = matches.length; _i < _len; _i++) {
          match = matches[_i];
          this.matches.append(new MatchView(this.model, {
            filePath: this.filePath,
            match: match
          }));
        }
      }
      if (selectedIndex > -1) {
        return this.matches.children().eq(selectedIndex).addClass('selected');
      }
    };

    ResultView.prototype.expand = function(expanded) {
      var firstResult, resultView, selected, selectedItem;
      if (expanded) {
        this.removeClass('collapsed');
        if (this.hasClass('selected')) {
          this.removeClass('selected');
          firstResult = this.find('.search-result:first').view();
          firstResult.addClass('selected');
          resultView = firstResult.closest('.results-view').view();
          resultView.scrollTo(firstResult);
        }
      } else {
        this.addClass('collapsed');
        selected = this.find('.selected').view();
        if (selected != null) {
          selected.removeClass('selected');
          this.addClass('selected');
          resultView = this.closest('.results-view').view();
          resultView.scrollTo(this);
        }
        selectedItem = this.find('.selected').view();
      }
      return this.isExpanded = expanded;
    };

    ResultView.prototype.confirm = function() {
      return this.expand(!this.isExpanded);
    };

    return ResultView;

  })(View);

}).call(this);
